import cld from 'cld'

const processText = async (body) =>{
    try {
        return new Promise(async (resolve,reject)=>{
                const result = await cld.detect(body, {isHTML:true});
                let languages = []
                result && result.languages && result.languages.forEach((language)=>{
                    languages.push(language.name)
                })
                resolve(languages)
        })
    } catch (error) {
        console.log("Error detecting language in body",error)
        resolve(false)
    }
}

export default{
    processText: (body)=>{
        return processText(body)
    }
}