import fs from 'fs';
import path from 'path';
import { google } from 'googleapis';

import crypto from '../crypto';
import getToken from './get-outlook-token';
import config from '../config';

const fromOutlook = async(credential) => {
    try {
        let token;
        if(credential.integrationType === 'Manual'){
            let tenantId = crypto.decrypt(credential['tenantId']);
            let clientId = crypto.decrypt(credential['clientId']);
            let clientSecret = crypto.decrypt(credential['clientSecret']);
            token = await getToken.getOutlookAuthToken(tenantId, clientId, clientSecret);
        }else if(credential.integrationType === 'Direct'){
            let clientId = config.azure.defaultDomainAppClientId;
            let clientSecret = config.azure.defaultDomainAppClientSecret;
            let tenantId = crypto.decrypt(credential['tenantId']);
            token = await getToken.getOutlookAuthToken(tenantId, clientId, clientSecret);
        }
        return { token }
    } catch (err) {
        throw new RequestError('Invalid credentials',429);
    }
}
export const fromGsuite = async(credential) => {
    try{
        const { adminEmail, fileName } = credential;
        let credentialFilePath = path.join(appRoot, 'Content', 'Credentials', fileName);
        if (fs.existsSync(credentialFilePath)) {
            const authClient = new google.auth.JWT({
                keyFile: credentialFilePath, 
                scopes: [ 
                    'https://mail.google.com/', 
                    'https://www.googleapis.com/auth/admin.directory.user',
                    'https://www.googleapis.com/auth/admin.directory.group.readonly'
                ],
                subject: adminEmail
            });
            await authClient.authorize();
            const service = google.admin({ version: 'directory_v1', auth: authClient });
            return { service, fileName };
        } else {
            throw new Error('Credential file not exists',429);
        }
    } catch(err){
        console.log(err)
        throw new RequestError("Invalid Credentials.",429);
    }
}

export default {
    getCredentials: async( companyId, domainId ) => {
        const domain = await db.Domain.findOne({ _id: domainId, companyId, deletedAt: null });
        if(domain){
            if(domain.domainType == 'Gsuite'){
                return fromGsuite(domain.credential);
            } else {
                return fromOutlook(domain.credential);
            }
        } else {
            return new RequestError('Invalid domain credentials',429)
        }
    }
}