import axios from "axios";
import config from "../config";

export let checkDeceptive = (url) => {
    return new Promise(resolve => {
        try {
            let axiosRequestConfig = {
                method: 'get',
                url: `https://webrisk.googleapis.com/v1/uris:search?key=AIzaSyAZVCszdndr1_yR-wpCjpF29tUwwD1lVe0&threatTypes=SOCIAL_ENGINEERING&threatTypes=MALWARE&threatTypes=UNWANTED_SOFTWARE&uri=${url}`,
                headers: {
                    'Content-Type': 'application/json'
                },
                ...(config.proxy.enableForGoogleAPIs && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            }
            axios(axiosRequestConfig)
            .then(res => res.data)
            .then(data => {
                if (data.threat) {
                    resolve(true);
                } else {
                    resolve(false);
                }
            })
            .catch(err => {
                console.log(JSON.stringify(err));
                resolve(false);
            })
        } catch (error) {
            console.log(error);
            resolve(false);
        }
    })
}

