import CryptoJS from "crypto-js";
import config from '../config'

const includedRoutes = [
    '/admin/change-password',
    '/admin/login',
    '/admin/register',
    '/admin/reset-password',
    '/settings/updateSmtp',
    '/settings/virus-total',
    '/domain/domain-credential-outlook',
    '/domain/domain-credential-gsuite'
    ];

export let decryptRequest = (req, res, next) => {
    if (req.method === 'OPTIONS') {
        return next();
    }
    console.log("Request Body",req.body)
        if (includedRoutes.includes(req.path)) {
            if ((req.method === 'POST') && req.body && typeof req.body === 'object') {
                try {
                    req.body = Object.fromEntries(
                        Object.entries(req.body).map(([key, value]) => {
                            const bytes = CryptoJS.AES.decrypt(value, config.crypto.secret);
                            return [key, JSON.parse(bytes.toString(CryptoJS.enc.Utf8))];
                        })
                    );
                } catch (error) {
                    console.error('Decryption failed:', error.message);
                    return res.status(400).json({ error: 'Invalid encrypted payload' });
                }
            }
        }
    
      next();
    };