export let md5HashCheck = async (hash) => {
    try {
        let md5HashCheck = await db.Indicator.findOne({ type: "FileHash-MD5", indicator: hash })
        if (md5HashCheck) return true;
        else false;

    } catch (error) {
        console.log(error);
    }
}

export let sha256HashCheck = async (hash) => {
    try {
        let sha256hashCheck = await db.Indicator.findOne({ type: "FileHash-SHA256", indicator: hash })
        if (sha256hashCheck) return true;
        else false;
    } catch (error) {
        console.log(error);
    }
}

export let sha1HashCheck = async (hash) => {
    try {
        let sha1HashCheck = await db.Indicator.findOne({ type: "FileHash-SHA1", indicator: hash })
        if (sha1HashCheck) return true;
        else false;
    } catch (error) {
        console.log(error);
    }
}
export let urlCheck = async (url) => {
    try {
        let url = 'http://' + url + '/';
        let urlCheck = await db.Indicator.findOne({ type: "URL", indicator: { $regex: '.*' + url + '.*' } })
        if (urlCheck) return true;
        else false;
    } catch (error) {
        console.log(error);
    }
}

export let checkDomain = async (domainName, hostName) => {
    try {
        let data = {};

        let hostname = await db.Indicator.findOne({ type: "hostname", indicator: { $regex: '.*' + domainName + '.*' } })

        if (hostname) data['domain'] = "success";
        else data['domain'] = "failed";

        let domain = await db.Indicator.findOne({ type: "domain", indicator: { $regex: '%' + hostName + '%' } })

        if (domain) data['hostname'] = "success";
        else data['hostname'] = "failed";

        return { data }

    } catch (error) {
        console.log(error);
        return error
    }

}

export let checkIp = async (ip) => {
    try {
        let checkIP = await db.Indicator.findOne({ type: "IPv4", indicator: ip })

        if (checkIP) return { IP: "True" }
        else return { IP: "False" }

    } catch (error) {
        console.log(error);
    }
}



