
const getGroups = (credential, partialGroupName) => {
    return new Promise((resolve, reject) => {
        try {
            const { service } = credential;
            const sanitizedGroupName = partialGroupName?.trim().replace(/\s+/g, '+');

            service.groups.list({
                customer: 'my_customer',
                orderBy: 'email',
                fields: 'groups(id,name)',
                ...(partialGroupName && {
                    query: `name:${sanitizedGroupName}*`
                })
            }, (err, res) => {
                if (err) {
                    console.error('The API returned an error:', err.message);
                    reject(err);
                } else {
                    const groups = res?.data?.groups ?? [];
                    resolve(groups);
                }
            });
        } catch (err) {
            console.error(err);
            reject(err);
        }
    });
};


export default {
    processGroups: async( creds, partialGroupName ) => {
        return getGroups(creds, partialGroupName);
    }
}
