import { queue } from '../kue';
import { updateSyncingStatusOfGroups } from './update-syncing-status-groups';

const getGsuiteUsers =  async ({
    emails,
    service,
  }) => {

    const users = [];
    await Promise.allSettled(emails.map(async email => {
      try {
        const user = await service.users.get({ userKey: email });
        users.push(user.data);
      } catch (err) {
        users[email] = err;
      }
    }));
    return users;
  }

const getUsers =  async (domainId, domainName, subDomainGroups, companyId, credential, NextPageToken = null, grp, isMirrorSync, allUsersGroupId, syncTs, pageIndex = 0) => {
    try {
        const { service } = credential;
        if(!grp.groupId) {
        service.users.list({
            customer: 'my_customer',
            orderBy: 'email',
            maxResults: 500,
            pageToken: NextPageToken || "",
        }, async (err, res) => {
            if (err) {
              await updateSyncingStatusOfGroups(grp._id, companyId)
                await db.Domain.updateOne(
                  {
                    _id: domainId,
                  },
                  {
                    isSyncingUser: false,
                    syncEndAt: new Date(),
                    isSyncingUserError: true,
                    isSyncingUserErrorFile: JSON.stringify(err)
                  }
                );
                return console.error('The API returned an error:', err.message);
            } else {
                const users = res?.data?.users?? [];
                console.log('----->',users)
                let nextLink = res?.data?.nextPageToken?? null;
                if (users.length){
                    queue.create('gsuite-user-save', { 
                        users: users, 
                        domainId, 
                        domainName,
                        companyId, 
                        subDomainGroups,
                        isLast: nextLink? false: true,
                        group:grp,
                        domainName,
                        isMirrorSync,
                        allUsersGroupId,
                        syncTs,
                        pageIndex,
                        isFirstPage: pageIndex === 0
                    }).removeOnComplete(true).priority('high').save()
                }
                if (nextLink) {
                    return getUsers(domainId, domainName, subDomainGroups, companyId, credential, nextLink, grp, isMirrorSync, allUsersGroupId, syncTs, pageIndex+1);
                }
            }
        });
        }
        else{
            service.groups.get(
                {
                  groupKey: grp.groupId,
                },
                async (err, res) => {
                  if (err) {
                    await updateSyncingStatusOfGroups(grp._id, companyId)
                    await db.Domain.updateOne(
                      {
                        _id: domainId,
                      },
                      {
                        isSyncingUser: false,
                        syncEndAt: new Date(),
                        isSyncingUserError: true,
                        isSyncingUserErrorFile: JSON.stringify(err),
                      }
                    );
                    return reject(new RequestError(err));
                  }
        
                  const group = res?.data;
                  if (!group) {
                    console.log(`Group with ID ${grp.groupId} not found.`)
                  }
        
                  async function loop(nextPageToken) {
                    // Fetching Group Members
                    service.members.list(
                      {
                        groupKey: group.email,
                        customer: 'my_customer',
                        orderBy: 'email',
                        maxResults: 500,
                        pageToken: nextPageToken || '',
                        // fields: 'members(id,email)'
                      },
                      async (membersErr, membersRes) => {
                        try {
                          if (membersErr) {
                            console.log("Error Fetching Group Members", membersErr)
                          }
        
                        const members = membersRes?.data?.members ?? [];
                        const membersObj = {};
                        members.forEach((m) => {
                          membersObj[m.email] = m;
                        });
         

                        console.log("members------>",members)

                        const users = await getGsuiteUsers({
                            emails: Object.keys(membersObj),
                            service,
                          });
                 
                        console.log("users------>",users)
        
                        queue.create('gsuite-user-save', { 
                        users: users, 
                        domainId, 
                        companyId, 
                        subDomainGroups,
                        isLast: nextPageToken? false: true,
                        group:grp, 
                        domainName,
                        isMirrorSync,
                        allUsersGroupId,
                        syncTs,
                        pageIndex,
                        isFirstPage: pageIndex === 0
                        }).removeOnComplete(true).priority('high').save()

                        const nextPageToken = res?.data?.nextPageToken ?? null;
                        if (!nextPageToken) {
                          console.log('all-users-tpir fetched');
                          return true;
                        }
        
                        loop(nextPageToken);
                        } catch (err) {
                          await updateSyncingStatusOfGroups(grp._id, companyId)
                          await db.Domain.updateOne(
                            {
                              _id: domainId,
                            },
                            {
                              isSyncingUser: false,
                              syncEndAt: new Date(),
                              isSyncingUserError: true,
                              isSyncingUserErrorFile: JSON.stringify(err),
                            }
                          );
                            console.log(err)
                        }
                      },
                    );
                  }
        
                  loop();
                },
              );
        }
    } catch (err) {
      console.log(err);
      await updateSyncingStatusOfGroups(grp._id, companyId)
        return db.Domain.updateOne({
            _id: domainId
        }, {
            isSyncingUser: false,
            syncEndAt: new Date(),
            isSyncingUserError: true,
            isSyncingUserErrorFile: JSON.stringify(err)
        })
    }
}

export default {
    processUser: (domainId, domainName, subDomainGroups, companyId, credential, nextPageToken=null, group) => {
        return getUsers(domainId, domainName, subDomainGroups, companyId, credential, nextPageToken, group);
    }
}