import axios from 'axios';
import config from '../config';

const getIpLocation = async function (ipAddress) {
    try {
        const axiosConfig = {};

        if (config.proxy.enableForIpLocation) {
            axiosConfig.httpsAgent = config.proxy.proxyAgent;
            axiosConfig.httpAgent = config.proxy.proxyAgent;
        }

        return new Promise((resolve, reject) => {
            axios.get(`https://www.iplocate.io/api/lookup/${ipAddress}?apikey=${config.iplocate.apikey}`,axiosConfig)
            .then(res => {
                if (res.data) {
                    let country = res.data.country;
                    let continent = res.data.continent;
                    resolve({ country, continent });
                } else {
                    resolve({ country: null, continent: null })
                }
            })
            .catch(err => {
                console.log(JSON.stringify(err));
                resolve({ country: null, continent: null })
            })
        })
    } catch (err) {
        console.log(err);
        resolve({ country: null, continent: null })
    }
}

export default {
    processIp: (ipAddress) => {
        return getIpLocation(ipAddress);
    }
}