import axios from "axios";
import config from "../config";

let axiosConfig = {
    httpsAgent: config.proxy.enableForMicrosoftGraph ? config.proxy.proxyAgent : undefined,
    httpAgent: config.proxy.enableForMicrosoftGraph ? config.proxy.proxyAgent : undefined,
};

const getHeader = (messageId, accessToken) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://outlook.office365.com/api/v2.0/me/messages/${messageId}?$select=SingleValueExtendedProperties&$expand=SingleValueExtendedProperties($filter=PropertyId eq 'String 0x007D')`;
        axios.get(getMessageUrl, {
            headers: {
                Authorization: "Bearer " + accessToken,
                Accept: "application/json; odata.metadata=none"
            },
            ...axiosConfig
        })
        .then(response => {
            if(response.data && response.data.SingleValueExtendedProperties && response.data.SingleValueExtendedProperties.length){
                resolve(response.data.SingleValueExtendedProperties[0].Value)
            } else {
                reject(new RequestError('Header not accessible'))
            }
        })
        .catch(err => {
            console.log("-------------------->",err.response.data)
            reject(err);
        })
    })
}

const getHeaderGraph = (messageId, accessToken, email) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://graph.microsoft.com/v1.0/users/${email}/messages/${messageId}?$select=internetMessageHeaders`;
        
        axios.get(getMessageUrl, {
            headers: {
                Authorization: `Bearer ${accessToken}`,
                Accept: "application/json"
            },
            ...axiosConfig
        })
        .then(response => {
            console.log(response.data.internetMessageHeaders)
            if (response.data && response.data.internetMessageHeaders) {
                // Find the specific header using its ID (0x007D corresponds to 'PR_TRANSPORT_MESSAGE_HEADERS')
                const header = response.data.internetMessageHeaders.find(h => h.name.toLowerCase() === "x-ms-exchange-organization-originalsize");
                
                if (header) {
                    resolve(header.value);
                } else {
                    reject(new Error('Header not found'));
                }
            } else {
                reject(new Error('Header data not accessible'));
            }
        })
        .catch(err => {
            console.log("-------------------->", err.response?.data || err.message);
            reject(err);
        });
    });
};


const getBody = (messageId, accessToken) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://outlook.office365.com/api/v2.0/me/messages/${messageId}`;
        axios.get(getMessageUrl, {
            headers: {
                Authorization: "Bearer " + accessToken,
                Accept: "application/json; odata.metadata=none"
            },
            ...axiosConfig
        })
        .then(response => {
            if(response.data && response.data.Body && response.data.Body.Content){
                resolve(response.data.Body.Content)
            } else {
                reject(new RequestError('Body not accessble'))
            }
        })
        .catch(err => {
            console.log("------------------->",err.response.data)
            reject(err);
        })
    })
}

const getAttachments = (messageId, accessToken) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://outlook.office365.com/api/v2.0/me/messages/${messageId}/attachments`;
        axios.get(getMessageUrl, {
            headers: {
                Authorization: "Bearer " + accessToken,
                Accept: "application/json; odata.metadata=none"
            },
            ...axiosConfig
        })
        .then(response => {
            resolve(response.data.value);
        })
        .catch(err => {
            console.log("------------------->",err.response.data)
            reject(err);
        })
    })
}



const getEml = (messageId, accessToken) =>{
    return new Promise((resolve, reject) => {
        var getMessageUrl =`https://outlook.office365.com/api/v2.0/me/messages/${messageId}/$value`;
        axios.get(getMessageUrl, {
            headers: {
                Authorization: "Bearer " + accessToken,
                Accept: "application/json; odata.metadata=none"
            },
            ...axiosConfig
        })
        .then(response => {
            resolve(response.data);
        })
        .catch(err => {
            reject(err);
        })
    })
}

const getBodyGraph = (messageId, accessToken, email) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://graph.microsoft.com/v1.0/users/${email}/messages/${messageId}?$select=body`;
        
        axios.get(getMessageUrl, {
            headers: {
                Authorization: `Bearer ${accessToken}`,
                Accept: "application/json"
            },
            ...axiosConfig
        })
        .then(response => {
            if (response.data && response.data.body && response.data.body.content) {
                resolve(response.data.body.content);
            } else {
                reject(new Error('Body not accessible'));
            }
        })
        .catch(err => {
            console.log("------------------->", err.response?.data || err.message);
            reject(err);
        });
    });
};

const getAttachmentsGraph = (messageId, accessToken, email) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://graph.microsoft.com/v1.0/users/${email}/messages/${messageId}/attachments`;
        
        axios.get(getMessageUrl, {
            headers: {
                Authorization: `Bearer ${accessToken}`,
                Accept: "application/json"
            },
            ...axiosConfig
        })
        .then(response => {
            resolve(response.data.value);
        })
        .catch(err => {
            console.log("------------------->", err.response?.data || err.message);
            reject(err);
        });
    });
};

const getEmlGraph = (messageId, accessToken, email) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://graph.microsoft.com/v1.0/users/${email}/messages/${messageId}/$value`;
        
        axios.get(getMessageUrl, {
            headers: {
                Authorization: `Bearer ${accessToken}`,
                Accept: "message/rfc822"
            },
            ...axiosConfig
        })
        .then(response => {
            resolve(response.data);
        })
        .catch(err => {
            console.log("------------------->", err.response?.data || err.message);
            reject(err);
        });
    });
};


const getFolderId = (messageId, accessToken) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://outlook.office365.com/api/v2.0/me/messages/${messageId}?$select=ParentFolderId`;
        axios.get(getMessageUrl, {
            headers: {
                Authorization: "Bearer " + accessToken,
                Accept: "application/json; odata.metadata=none"
            },
            ...axiosConfig
        })
        .then(response => {
            resolve(response.data.ParentFolderId);
        })
        .catch(err => {
            console.log("------------------->",err.response.data)
            reject(err);
        })
    })
}

const getFolderIdGraph = (messageId, accessToken, email) => {
    return new Promise((resolve, reject) => {
        var getMessageUrl = `https://graph.microsoft.com/v1.0/users/${email}/messages/${messageId}?$select=parentFolderId`;
        
        axios.get(getMessageUrl, {
            headers: {
                Authorization: `Bearer ${accessToken}`,
                Accept: "application/json"
            },
            ...axiosConfig
        })
        .then(response => {
            resolve(response.data.parentFolderId);
        })
        .catch(err => {
            console.log("------------------->", err.response?.data);
            reject(err);
        });
    });
};

const moveToJunk = (messageId, accessToken, email) => {
    return new Promise((resolve, reject) => {
        const moveMessageUrl = `https://graph.microsoft.com/v1.0/users/${email}/messages/${messageId}/move`;

        axios.post(moveMessageUrl, 
            { destinationId: "deleteditems" }, 
            {
                headers: {
                    Authorization: `Bearer ${accessToken}`,
                    Accept: "application/json",
                    "Content-Type": "application/json"
                },
                ...axiosConfig
            }
        )
        .then(response => {
            console.log("-------------------Email Moved To Trash Successfully!--------------------")
            resolve(response.data);
        })
        .catch(err => {
            console.log("------------------->", err.response?.data);
            reject(err);
        });
    });
};


export default {
    processMail: async(messageId, accessToken) => {
        let body = await getBody(messageId, accessToken);
        let headers = await getHeader(messageId, accessToken);
        return `${headers}\r\n${body}`
    },
    processHeader: async(messageId, accessToken) => {
        return getHeader(messageId, accessToken);
    },
    processHeaderGraph: async(messageId, accessToken, email) => {
        return getHeaderGraph(messageId, accessToken, email);
    },
    processBody: async(messageId, accessToken) => {
        return getBody(messageId, accessToken);
    },
    processBodyGraph: async(messageId, accessToken, email) => {
        return getBodyGraph(messageId, accessToken, email);
    },
    processAttachments: async(messageId, accessToken) => {
        return getAttachments(messageId, accessToken);
    },
    processAttachmentsGraph: async(messageId, accessToken, email) => {
        return getAttachmentsGraph(messageId, accessToken, email);
    },
    processEml: async(messageId, accessToken) =>{
        return getEml(messageId,accessToken);
    },
    processEmlGraph: async(messageId, accessToken, email) =>{
        return getEmlGraph(messageId,accessToken, email);
    },
    processFolderId: async(messageId, accessToken) =>{
        return getFolderId(messageId, accessToken)
    },
    processFolderIdGraph: async(messageId, accessToken, email) =>{
        return getFolderIdGraph(messageId, accessToken, email)
    },
    moveEmailToJunk: async(messageId, accessToken, email) =>{
        return moveToJunk(messageId, accessToken, email)
    }
}