import axios from 'axios';
import credentials from "./credentials";
import config from '../config';

const getGroups = async (credential,partialGroupName) =>{
    try {
        let axiosConfig = {
            httpsAgent: config.proxy.enableForMicrosoftGraph ? config.proxy.proxyAgent : undefined,
            httpAgent: config.proxy.enableForMicrosoftGraph ? config.proxy.proxyAgent : undefined,
        };
        console.log({partialGroupName})
        let axiosRequestConfig = {
            method: 'GET',
            url: partialGroupName ?`https://graph.microsoft.com/v1.0/groups?$filter=startswith(displayName, '${partialGroupName}')&$top=999`:
            'https://graph.microsoft.com/v1.0/groups?$select=id,displayName&$top=999',
            headers: { 
                'content-type': 'application/json', 
                authorization: `Bearer ${credential.token.access_token}` 
            },
            ...axiosConfig
        };
        let apiRespo = await axios.request(axiosRequestConfig) 
        if(apiRespo && apiRespo.data) return apiRespo.data.value
    } catch (error) {
        console.log(error.response.data)
        throw new RequestError("Error fetching groups")
    }
} 

export default {
    processGroups: async( creds, partialGroupName ) => {
        return getGroups(creds, partialGroupName);
    }
}