import axios from "axios";
import config from "../config";

export default {
    getOutlookAuthToken: (tenantId, clientId, clientSecret) => {
        return new Promise(async (resolve, reject) => {
            let axiosRequestConfig = {
                method: 'POST',
                url: `https://login.microsoftonline.com/${tenantId}/oauth2/v2.0/token`,
                headers: { 
                    'content-type': 'application/x-www-form-urlencoded' 
                },
                data: new URLSearchParams({
                    client_id: clientId,
                    client_secret: clientSecret,
                    grant_type: 'client_credentials',
                    scope: 'https://graph.microsoft.com/.default'
                }),
                ...(config.proxy.enableForMicrosoftGraph && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            };
            axios.request(axiosRequestConfig)
            .then(res => {
                resolve(res.data);
            })
            .catch(err => {
                reject(err);
            })
        })
    } 
}