import axios from 'axios';
import { queue } from '../kue';
import { updateSyncingStatusOfGroups } from './update-syncing-status-groups';
import config from '../config';

const getUsers = async(domainId, domainName, subDomainGroups, companyId, credential, nextLink, isExchange, group, isMirrorSync, allUsersGroupId, syncTs, pageIndex=0) => {
    try {
        console.log("------------test------------")
        console.log({condition: group.groupId})
        if(group && group.groupId != null){
            var axiosRequestConfig = {
                method: 'GET',
                url: nextLink ? nextLink : `https://graph.microsoft.com/v1.0/groups/${group.groupId}/members?$top=999`,
                headers: {
                    'content-type': 'application/json',
                    authorization: `Bearer ${credential.token.access_token}`
                },
                ...(config.proxy.enableForMicrosoftGraph && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            };
        }
        else {
            var axiosRequestConfig = {
            method: 'GET',
            url: nextLink ? nextLink : 'https://graph.microsoft.com/v1.0/users?$select=*&$top=999',
            headers: { 
                'content-type': 'application/json', 
                authorization: `Bearer ${credential.token.access_token}` 
            },
            ...(config.proxy.enableForMicrosoftGraph && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
        }
        }
        let apiRespo = await axios.request(axiosRequestConfig)
        if (apiRespo && apiRespo.data){
            let orgUsers = apiRespo.data.value??[];
            let nextLink = apiRespo.data['@odata.nextLink'] ? apiRespo.data['@odata.nextLink'] : null;
            if (orgUsers){
                console.log({orgUsers})
                queue.create('outlook-user-save', { 
                    users: orgUsers, 
                    domainId, 
                    domainName,
                    subDomainGroups,
                    companyId, 
                    isLast: nextLink? false: true,
                    isExchange,
                    group,
                    isMirrorSync,
                    allUsersGroupId,
                    syncTs,
                    isFirstPage: pageIndex === 0
                }).removeOnComplete(true).priority('high').save()
            }
            if (nextLink) {
                if(isExchange) return getUsers(domainId, domainName, subDomainGroups, companyId, credential, nextLink, true, group, isMirrorSync, allUsersGroupId, syncTs, pageIndex+1)
                else return getUsers(domainId, domainName, subDomainGroups, companyId, credential, nextLink, false, group, isMirrorSync, allUsersGroupId, syncTs, pageIndex+1)
            }   
        } else {
            await updateSyncingStatusOfGroups(group._id,companyId)
            return true;
        }
    } catch (error) {
        // console.log(error)
        console.log(error?.response?.data)
        await updateSyncingStatusOfGroups(group._id,companyId)

        await db.Domain.updateOne({
            _id: domainId
        }, {
            isSyncingUser: false,
            syncEndAt: new Date(),
            isSyncingUserError:true,
            isSyncingUserErrorFile: JSON.stringify(error)
        })
        return new RequestError('Error syncing user');    
    }
}
export default {
    processUser: (domainId, domainName, subDomainGroups, companyId, credential, nextLink, isExchange, groupId, groupName, isMirrorSync, allUsersGroupId, syncTs, pageIndex) => {
        return getUsers(domainId, domainName, subDomainGroups, companyId, credential, nextLink, isExchange, groupId, groupName, isMirrorSync, allUsersGroupId, syncTs, pageIndex);
    }
}