import axios from 'axios'

import config from '../config'

export default {
    getHackRecord: (email) => {
        return new Promise((resolve, reject) => {
            axios({
                method: 'GET',
                url: `${config.hackRecord.url}/api/v3/breachedaccount/${email}?truncateResponse=false`,
                headers: {
                    'User-Agent': 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36',
                    'hibp-api-key': config.hackRecord.apiKey
                },
                ...(config.proxy.enableForHIBP && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            })
            .then(result => {
                resolve(result);
            })
            .catch(err => {
                reject(err && err.message? new RequestError(err.message, 404): new RequestError('Error fetching hack record', 404));
            })
        })
    }
}