const vision = require('@google-cloud/vision');
const {GoogleAuth, grpc} = require('google-gax');
import config from '../config';
const apiKey = config.imageToText.apiKey;
import path from 'path';


function getApiKeyCredentials() {
    const sslCreds = grpc.credentials.createSsl();
    const googleAuth = new GoogleAuth();
    const authClient = googleAuth.fromAPIKey(apiKey);
    const credentials = grpc.credentials.combineChannelCredentials(
      sslCreds,
      grpc.credentials.createFromGoogleCredential(authClient)
    );
    return credentials;
  }

const scanResult = (data) => {
	return new Promise(async(resolve, reject) => {
    try {
      const sslCreds = getApiKeyCredentials();
        const client = new vision.ImageAnnotatorClient({sslCreds});
        const [result] = await client.textDetection(path.join( appRoot, "Content", "whatsappImages", data));
        resolve(result?.fullTextAnnotation?.text);
    } catch (error) {
      console.log("Error From Vision API while Converting Image-To-Text",error)
      resolve(false)
    }
	})
}
export default {
    imageToText: async(data) => {
        return scanResult(data)
    }
}