const messages = {
    acknowledgmentMessage: {
      english: (ticketId) => `*Ticket ID - ${ticketId}*. \n\nThank you for reporting to us. We will shortly provide you with the results.\n\n\`Thank you for the commitment to online safety.\``,
      indonesian: (ticketId) => `*Tiket ID - ${ticketId}*. \n\nTerima kasih telah melaporkan kepada kami. Kami akan segera memberikan hasilnya.\n\n\`Terima kasih atas komitmen Anda terhadap keamanan online.\``,
      arabic: (ticketId) => `*معرف التذكرة* - ${ticketId} \n\nشكرًا لك على الإبلاغ. سنقدم لك النتائج قريبًا.\n\n\`شكرًا لك على التزامك بالسلامة عبر الإنترنت.\``,
      french: (ticketId) => `*Ticket ID - ${ticketId}*. \n\nMerci de nous avoir signalé ce problème. Nous vous fournirons bientôt les résultats.\n\n\`Merci pour votre engagement envers la sécurité en ligne.\``,
      spanish: (ticketId) => `*Ticket ID - ${ticketId}*. \n\nGracias por informarnos. En breve le proporcionaremos los resultados.\n\n\`Gracias por su compromiso con la seguridad en línea.\``,
      german: (ticketId) => `*Ticket ID - ${ticketId}*. \n\nDanke, dass Sie uns informiert haben. Wir werden Ihnen in Kürze die Ergebnisse mitteilen.\n\n\`Vielen Dank für Ihr Engagement für die Online-Sicherheit.\``,
      russian: (ticketId) => `*Ticket ID - ${ticketId}*. \n\nСпасибо за ваше сообщение. В ближайшее время мы предоставим вам результаты.\n\n\`Спасибо за приверженность онлайн-безопасности.\``,
      chinese_simplified: (ticketId) => `*Ticket ID - ${ticketId}*. \n\n感谢您的举报。我们将很快提供结果。\n\n\`感谢您对网络安全的承诺。\``,
      chinese_traditional: (ticketId) => `*Ticket ID - ${ticketId}*. \n\n感謝您的舉報。我們將很快提供結果。\n\n\`感謝您對網絡安全的承諾。\``,
      japanese: (ticketId) => `*Ticket ID - ${ticketId}*. \n\nご報告いただきありがとうございます。結果は間もなくお知らせします。\n\n\`オンライン安全へのご協力に感謝します。\``,
      korean: (ticketId) => `*Ticket ID - ${ticketId}*. \n\n신고해 주셔서 감사합니다. 곧 결과를 제공하겠습니다.\n\n\`온라인 안전을 위한 노력에 감사드립니다.\``
    },
  
    investigationMessage: {
      english: (ticketId, overallResult, summary) => `*Ticket Id* - ${ticketId} \n\nPlease find the investigation report below.\n\n*Investigated Content* - \nSafety Parameter - ${overallResult}\n\n${summary}\n\n\`Thank you for the commitment to online safety.\``,
      indonesian: (ticketId, overallResult, summary) => `*Tiket Id* - ${ticketId} \n\nSilakan temukan laporan investigasi di bawah ini.\n\n*Konten yang Diselidiki* - \nParameter Keamanan - ${overallResult}\n\n${summary}\n\n\`Terima kasih atas komitmen Anda terhadap keamanan online.\``,
      arabic: (ticketId, overallResult, summary) => `*معرف التذكرة* - ${ticketId} \n\nيرجى العثور على تقرير التحقيق أدناه.\n\n*المحتوى الذي تم التحقيق فيه* - \nمعامل الأمان - ${overallResult}\n\n${summary}\n\n\`شكرًا لك على التزامك بالسلامة عبر الإنترنت.\``,
      french: (ticketId, overallResult, summary) => `*Ticket Id* - ${ticketId} \n\nVeuillez trouver le rapport d'enquête ci-dessous.\n\n*Contenu Enquêté* - \nParamètre de sécurité - ${overallResult}\n\n${summary}\n\n\`Merci pour votre engagement envers la sécurité en ligne.\``,
      spanish: (ticketId, overallResult, summary) => `*Ticket Id* - ${ticketId} \n\nPor favor, encuentre el informe de investigación a continuación.\n\n*Contenido Investigado* - \nParámetro de seguridad - ${overallResult}\n\n${summary}\n\n\`Gracias por su compromiso con la seguridad en línea.\``,
      german: (ticketId, overallResult, summary) => `*Ticket Id* - ${ticketId} \n\nBitte finden Sie den Untersuchungsbericht unten.\n\n*Untersuchter Inhalt* - \nSicherheitsparameter - ${overallResult}\n\n${summary}\n\n\`Vielen Dank für Ihr Engagement für die Online-Sicherheit.\``,
      russian: (ticketId, overallResult, summary) => `*Ticket Id* - ${ticketId} \n\nНиже приведен отчет о расследовании.\n\n*Исследованный контент* - \nПараметр безопасности - ${overallResult}\n\n${summary}\n\n\`Спасибо за вашу приверженность онлайн-безопасности.\``,
      chinese_simplified: (ticketId, overallResult, summary) => `*Ticket Id* - ${ticketId} \n\n请查收以下调查报告。\n\n*调查内容* - \n安全参数 - ${overallResult}\n\n${summary}\n\n\`感谢您对网络安全的承诺。\``,
      chinese_traditional: (ticketId, overallResult, summary) => `*Ticket Id* - ${ticketId} \n\n請查收以下調查報告。\n\n*調查內容* - \n安全參數 - ${overallResult}\n\n${summary}\n\n\`感謝您對網絡安全的承諾。\``
    }
  };
  

  function getLanguageFormattedMessage(messageType, preferedLanguage, params) {
    return new Promise((resolve, reject) => {
      try {
        let message;
        const language = (typeof preferedLanguage === 'string' && preferedLanguage.length > 0)
                          ? preferedLanguage.toLowerCase() : 'english';
        if (messageType === "acknowledgment") {
          message = messages.acknowledgmentMessage[language] 
            ? messages.acknowledgmentMessage[language](params.ticketId) 
            : messages.acknowledgmentMessage.english(params.ticketId); 
        } else if (messageType === "investigation") {
          message = messages.investigationMessage[language] 
            ? messages.investigationMessage[language](params.ticketId, params.overallResult, params.summary) 
            : messages.investigationMessage.english(params.ticketId, params.overallResult, params.summary); 
        } else {
          return reject(new Error("Invalid message type"));
        }
        resolve(message);
      } catch (error) {
        reject(error);
      }
    });
  }
  
  export default getLanguageFormattedMessage