import axios from "axios";
import config from "../config";

export let licenceCheck = (licenceKey, date) => {
    return new Promise((resolve, reject) => {

        let newDate = new Date(new Date(date).setDate(new Date(date).getDate()+14));
        try {
            let options = {
                method: 'get',
                url: `${config.app.adminURL}/api/v1/client/details?licenceKey=${licenceKey}`,
                headers: {
                    'Content-Type': 'application/json'
                }
            }
            axios(options)
            .then(res => res.data)
            .then(data => {
                resolve(data?.client? data.client:{
                    userLimit: 10,
                    domainLimit: 1,
                    expiresAt: newDate
                });
            })
            .catch(err => {
                console.log(err);
                resolve({
                    userLimit: 10,
                    domainLimit: 1,
                    expiresAt: newDate
                })
            })
        } catch (err) {
            console.log(err);
            resolve({
                userLimit: 10,
                domainLimit: 1,
                expiredAt: newDate
            })
        }
    })
}

