import {queue} from '../kue'
import mailer from '../mailer'
import credentials from './credentials'
import moveEmailGsuite from './move-email-gsuite'
import moveEmailOutlook from './move-email-outlook'
import { updateReportedMailCache } from '../functions'
 
export let callMailActionApi = async (reportedMailId, action) =>{
    try {
        let whoElseEmails = await db.WhoElse.find({reportedMailId})
        console.log({whoElseEmails})
        let whoElseIds = [];
        
        
        for(let i = 0; i<whoElseEmails.length; i++){
           whoElseIds.push(whoElseEmails[i]._id)
        }
        

        const emailReported = await db.ReportedMail.findOne({
          _id: reportedMailId,
          // companyId
        })
        const companyId = emailReported.companyId;
  
        if(!emailReported){
            throw new RequestError('invalid reportedMailId recieved');
        }
        
        // const domain = await db.Domain.findOne({
        //     _id: emailReported.domainId, companyId, deletedAt:null
        // })
        // if(!domain){
        //     throw new RequestError('invalid domain or deleted');
        // }
  
        // if(domain.isCredential == false){
        //     throw new RequestError('Domain credentials not set');   
        // }

        if(action=='trash'){
            if(emailReported.mailType == 'Exchange'){
                const user = await db.User.findOne({ email: emailReported.to })
                mailer.sendActionResultMail(user.name ,emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SPAM", false, "", companyId)      
                if(emailReported.reporters.length!=0 ){
                    emailReported.reporters.forEach(async (email)=>{
                        const user = await db.User.findOne({ email })
                        mailer.sendActionResultMail(user.name ,email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime,"SPAM", false, "", companyId) 
                    })
                }
                emailReported.isRecoveredEmail = false;
                emailReported.isTrashedEmail = true;
                await emailReported.save()
                return res.status(200).send({ success: true, Message: "Successfully marked as Spam!"})
            }
            else{
                {
                    let whoElseIdsDomainWise = {};
        
                    let whoElses = []
                    var gsuiteIds = []
                    
                    for(const whoElse of whoElseIds){
                        let result = await db.WhoElse.findOne({companyId, _id: whoElse}).populate('domainId' ,'domainType _id')
                        if(result.domainId.domainType == 'Gsuite') gsuiteIds.push(result)
                        else whoElses.push(result)
                    }
        
                    for(let i=0;i<whoElses.length;i++){
                        let whoElse = whoElses[i]
                        if(!whoElseIdsDomainWise[whoElse.domainId._id])  whoElseIdsDomainWise[whoElse.domainId._id] = []
        
                        
                        if(whoElseIdsDomainWise[whoElse.domainId._id].length > 0){
                            let lastArray = whoElseIdsDomainWise[whoElse.domainId._id].pop()
                            if(lastArray.length < 20) lastArray.push(whoElse), whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray)
                            else whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray), whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse])
                        }
                        else whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse])
                    }      
        
                    
                    for(const domainWhoelse in whoElseIdsDomainWise){
                        for(let i=0;i<whoElseIdsDomainWise[domainWhoelse].length; i+=10){
                            queue.create('process-update-folderId-outlook',{whoElses: whoElseIdsDomainWise[domainWhoelse].slice(i,Math.min(i+10,whoElseIdsDomainWise[domainWhoelse].length)), 
                                domainId: domainWhoelse, companyId, 
                                emailReported,
                                mailAction:'Trashed' })
                            .removeOnComplete(true).priority('high').save();
                        }
                    }
                    
                }
                if(gsuiteIds.length>0){
                    for(let i=0;i<gsuiteIds.length;i++){
                        let whoElse = await db.WhoElse.findOne({_id: gsuiteIds[i]})
                        if(whoElse.messageId && whoElse.threadId){
                            let { fileName } = await credentials.getCredentials(companyId, whoElse.domainId)
                            await moveEmailGsuite.processMoveEmailTrash({
                                fileName, 
                                email: whoElse.to,
                                threadId: whoElse.threadId,
                                messageId: whoElse.messageId,
                            })
                            .then(async () => {
                                whoElse.isErrorWhileMoving = {
                                    isError: false,
                                    message: ''
                                }
                                whoElse.isTrashed = true;
                                await whoElse.save();
        
                                if(emailReported.to !== whoElse.to) mailer.sendResultMailToOtherReporters(whoElse.name ,whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Trashed', companyId)
                                else mailer.sendActionResultMail(whoElse.name ,whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'TRASHED', false, null, companyId)
                            
                                return ;
                            })
                            .catch(async err => {
                                whoElse.isErrorWhileMoving = {
                                    isError: true,
                                    message: err
                                }
                                await whoElse.save();
                                return ;
                            })
                        } else {
                            whoElse.isErrorWhileMoving = {
                                isError: true,
                                message: 'messageId or threadId is missing'
                            }
                            await whoElse.save();
                        }
                    }
                    }
                }
                updateReportedMailCache(reportedMailId, {isTrashedEmail:'true',isRecoveredEmail:'false'})
                emailReported.isRecoveredEmail = false;
                emailReported.isTrashedEmail = true;
                await emailReported.save()
            }
        else if(action =='delete'){
            if(emailReported.mailType == 'Exchange'){
                const user = await db.User.findOne({ email: emailReported.to })
                mailer.sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "THREAT", false, "", companyId)      
                if(emailReported.reporters.length!=0 ){
                    emailReported.reporters.forEach(async (email)=>{
                        const user = await db.User.findOne({ email })
                        mailer.sendActionResultMail(user.name, email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime,"THREAT", false, "", companyId) 
                    })
                }
                emailReported.isRecoveredEmail = false;
                emailReported.isTrashedEmail = false;
                emailReported.isDeletedEmail = true;
                await emailReported.save()
                return res.status(200).send({ success: true, Message: "Successfully marked as deleted!"})
            }
            else{
                let whoElseIdsDomainWise = {};

                let whoElses = []
                var gsuiteIds = []
                
                for(const whoElse of whoElseIds){
                    let result = await db.WhoElse.findOne({companyId, _id: whoElse}).populate('domainId' ,'domainType _id')
                    if(result.domainId.domainType == 'Gsuite') gsuiteIds.push(result)
                    else whoElses.push(result)
                }
    
                for(let i=0;i<whoElses.length;i++){
                    let whoElse = whoElses[i]
                    if(!whoElseIdsDomainWise[whoElse.domainId._id])  whoElseIdsDomainWise[whoElse.domainId._id] = []
    
                    
                    if(whoElseIdsDomainWise[whoElse.domainId._id].length > 0){
                        let lastArray = whoElseIdsDomainWise[whoElse.domainId._id].pop()
                        if(lastArray.length < 20) lastArray.push(whoElse), whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray)
                        else whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray), whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse])
                    }
                    else whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse])
                }      
    
                console.log('------>',whoElseIdsDomainWise)
                
                for(const domainWhoelse in whoElseIdsDomainWise){
                    let count = 0
                    for(let i=0;i<whoElseIdsDomainWise[domainWhoelse].length; i+=10){
                        queue.create('process-update-folderId-outlook',{whoElses: whoElseIdsDomainWise[domainWhoelse].slice(i,Math.min(i+10,whoElseIdsDomainWise[domainWhoelse].length)), 
                            domainId: domainWhoelse, companyId, 
                            emailReported,
                            mailAction:'Deleted' })
                        .removeOnComplete(true).priority('high').save();
                    }
                }
                
            }
            if(gsuiteIds.length>0){
                for(let i=0;i<gsuiteIds.length;i++){
                    let whoElse = await db.WhoElse.findOne({_id: gsuiteIds[i]})
                    if(whoElse.messageId && whoElse.threadId){
                        let { fileName } = await credentials.getCredentials(companyId, whoElse.domainId)
                        await moveEmailGsuite.processMoveEmailDelete({
                            fileName, 
                            email: whoElse.to,
                            threadId: whoElse.threadId,
                            messageId: whoElse.messageId, 
                        })
                        .then(async () => {
                            whoElse.isErrorWhileMoving = {
                                isError: false,
                                message: ''
                            }
                            whoElse.isDeleted = true;
                            await whoElse.save();
                            
                            if(emailReported.to !== whoElse.to) mailer.sendResultMailToOtherReporters(whoElse.name ,whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Deleted', companyId)
                            else mailer.sendActionResultMail(whoElse.name ,whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'DELETED', false, null, companyId)
                               
                            return ;
                        })
                        .catch(async err => {
                            whoElse.isErrorWhileMoving = {
                                isError: true,
                                message: err
                            }
                            await whoElse.save();
                            return ;
                        })
                    } else {
                        whoElse.isErrorWhileMoving = {
                            isError: true,
                            message: 'messageId or threadId is missing'
                        }
                        await whoElse.save();
                    }
                }

            }
            updateReportedMailCache(reportedMailId, {isTrashedEmail:'false',isRecoveredEmail:'false',isDeletedEmail:'true'})
            emailReported.isRecoveredEmail = false;
            emailReported.isTrashedEmail = false;
            emailReported.isDeletedEmail = true;
            await emailReported.save()
        }
        else{
            if(emailReported.mailType == 'Exchange'){
                const user = await db.User.findOne({ email: emailReported.to })
                if(emailReported.fileName == null) mailer.sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SAFE", false, "", companyId)      
                else mailer.sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime,"SAFE", true, emailReported.fileName, companyId) 
                if(emailReported.reporters.length!=0 ){
                    emailReported.reporters.forEach(async (email)=>{
                        const user = await db.User.findOne({ email })
                        if(emailReported.fileName == null) mailer.sendActionResultMail(user.name, email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SAFE", false, "", companyId)      
                        else mailer.sendActionResultMail(user.name, email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime,"SAFE", true, emailReported.fileName, companyId) 
                    })
                }
                emailReported.isRecoveredEmail = true;
                emailReported.isTrashedEmail = false;
                await emailReported.save()
                return res.status(200).send({ success: true, Message: "Successfully marked as safe!"})
            }
            else{
            let whoElseIdsDomainWise = {};

            let whoElses = []
            var gsuiteIds = []
            
            for(const whoElse of whoElseIds){
                let result = await db.WhoElse.findOne({companyId, _id: whoElse}).populate('domainId' ,'domainType _id')
                console.log(result)
                if(result.domainId.domainType == 'Gsuite') gsuiteIds.push(result)
                else whoElses.push(result)
            }

            for(let i=0;i<whoElses.length;i++){
                let whoElse = whoElses[i]
                if(!whoElseIdsDomainWise[whoElse.domainId._id])  whoElseIdsDomainWise[whoElse.domainId._id] = []

                
                if(whoElseIdsDomainWise[whoElse.domainId._id].length > 0){
                    let lastArray = whoElseIdsDomainWise[whoElse.domainId._id].pop()
                    if(lastArray.length < 20) lastArray.push(whoElse), whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray)
                    else whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray), whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse])
                }
                else whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse])
            }      

            
            for(const domainWhoelse in whoElseIdsDomainWise){
                for(let i=0;i<whoElseIdsDomainWise[domainWhoelse].length; i+=10){
                    queue.create('process-update-folderId-outlook',{whoElses: whoElseIdsDomainWise[domainWhoelse].slice(i,Math.min(i+10,whoElseIdsDomainWise[domainWhoelse].length)), 
                        domainId: domainWhoelse, companyId, 
                        emailReported,
                        mailAction:'Recovered' })
                    .removeOnComplete(true).priority('high').save();
                }
            }
            
        }
        if(gsuiteIds.length>0){
            for(let i=0;i<gsuiteIds.length;i++){
                let whoElse = await db.WhoElse.findOne({_id: gsuiteIds[i]})
                if(whoElse.messageId && whoElse.threadId){
                    let { fileName } = await credentials.getCredentials(companyId, whoElse.domainId)
                    await moveEmailGsuite.processMoveEmailInbox({
                        fileName, 
                        email: whoElse.to,
                        threadId: whoElse.threadId,
                        messageId: whoElse.messageId,
                    })
                    .then(async () => {
                        whoElse.isErrorWhileMoving = {
                            isError: false,
                            message: ''
                        }
                        whoElse.isTrashed = false;
                        await whoElse.save();

                        if(emailReported.to !== whoElse.to) mailer.sendResultMailToOtherReporters(whoElse.name ,whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Recovered', companyId)
                        else mailer.sendActionResultMail(whoElse.name ,whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'RECOVERED', false, null, companyId)
                        
                        return ;
                    })
                    .catch(async err => {
                        whoElse.isErrorWhileMoving = {
                            isError: true,
                            message: err
                        }
                        await whoElse.save();
                        return ;
                    })
                } else {
                    whoElse.isErrorWhileMoving = {
                        isError: true,
                        message: 'messageId or threadId is missing'
                    }
                    await whoElse.save();
                }
            }
        }
        updateReportedMailCache(reportedMailId, {isTrashedEmail:'false',isRecoveredEmail:'true'})
        emailReported.isRecoveredEmail = true;
        emailReported.isTrashedEmail = false;
        await emailReported.save()
        }
        
        
      } catch (error) {
        console.log('Erooooor',error);
        return error
      }
    
  }