
import path from 'path';
import { gmail_v1, google } from 'googleapis' ;

const getAuthentication = async(fileName, email) => {
    const authClient = new google.auth.JWT({
        keyFile: path.join(appRoot, 'Content', 'Credentials', fileName),
        scopes: [
            'https://mail.google.com/', 
            'https://www.googleapis.com/auth/admin.directory.user'
        ],
        subject: email,
    });
    await authClient.authorize();
    const gmail =  new gmail_v1.Gmail({ auth: authClient });
    return { gmail, authClient };
}

const moveEmailTrash = ({ email, messageId, threadId, fileName }) => {
    return new Promise( async (resolve, reject) => {
        const { gmail, authClient } = await getAuthentication(fileName, email);
        const result = await gmail.users.messages.modify({
            id: threadId || messageId,
            auth: authClient,
            userId: email, 
            requestBody: {
                "addLabelIds": [
                    "TRASH"
                ],
                "removeLabelIds": [
                    "INBOX"
                ]
            }
        })
        resolve(result)
    })
}

const moveEmailDelete = ({ email, messageId, threadId, fileName }) => {
    return new Promise( async (resolve, reject) => {
        const { gmail, authClient } = await getAuthentication(fileName, email);
        const result = await gmail.users.messages.delete({
            id: threadId || messageId,
            auth: authClient,
            userId: email
        })
        resolve(result)
    })
}

const moveEmailInbox = ({ email, messageId, threadId, fileName }) => {
    return new Promise( async (resolve, reject) => {
        const { gmail, authClient } = await getAuthentication(fileName, email);
        const result = await gmail.users.messages.modify({
            id: threadId || messageId,
            auth: authClient,
            userId: email, 
            requestBody: {
                "addLabelIds": [
                    "INBOX"
                ],
                "removeLabelIds": [
                    "TRASH"
                ]
            }
        })
        resolve(result)
    })
}

export default {
    processMoveEmailTrash: (data) => {
        return moveEmailTrash(data);
    },
    processMoveEmailDelete: (data) => {
        return moveEmailDelete(data);
    },
    processMoveEmailInbox: (data) => {
        return moveEmailInbox(data);
    }
}