import axios from "axios";
import config from "../config";

let outlookBatchProcess = async (requests, token) => {
    let data = { requests };
    let axiosRequestConfig = {
        method: 'POST',
        url: 'https://graph.microsoft.com/v1.0/$batch/',
        headers: { "content-type": "application/json", authorization: `Bearer ${token}`, Prefer: 'outlook.allow-unsafe-operations'},
        data: JSON.stringify(data),
        ...(config.proxy.enableForMicrosoftGraph && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
    }
    let response = await axios.request(axiosRequestConfig)
    let result = response.data.responses
    return result;
}

const moveEmailTrash = (whoElseBatches) => {
    return new Promise(async (resolve, reject) => {
        let trashRequests = []

        for(let i =0;i<whoElseBatches.length;i++){
            let moveToTrashApi = `/users/${whoElseBatches[i].email}/messages/${whoElseBatches[i].messageId}/move`
            let moveToTrashReq = {
                id: whoElseBatches[i].id,
                method: 'POST',
                url: moveToTrashApi,
                headers: { 
                "Authorization": `Bearer ${whoElseBatches[i].token}`,
                "Content-Type": "application/json"
                }, 
                body : { "destinationId": "deleteditems" }
            };
            trashRequests.push(moveToTrashReq)
        }
        let trashResponses = []
        trashResponses = await outlookBatchProcess(trashRequests,whoElseBatches[0].token)
        resolve(trashResponses)
    })
}

const moveEmailDelete = (whoElseBatches) => {
    return new Promise(async (resolve, reject) => {
        let deleteRequests = []
        
        for(let i =0;i<whoElseBatches.length;i++){
            let deleteApi = `/users/${whoElseBatches[i].email}/messages/${whoElseBatches[i].messageId}`
            let deleteReq = {
                id: whoElseBatches[i].id,
                method: 'DELETE',
                url: deleteApi,
                headers: { 
                "Authorization": `Bearer ${whoElseBatches[i].token}`,
                "Content-Type": "application/json"
                }, 
            };
            deleteRequests.push(deleteReq)
        }
        let deleteResponses = []
        deleteResponses = await outlookBatchProcess(deleteRequests,whoElseBatches[0].token)

        resolve(deleteResponses)
    })
}

const moveEmailInbox = (whoElseBatches) => {
    return new Promise(async (resolve, reject) => {
        let recoverRequests = []

        for(let i =0;i<whoElseBatches.length;i++){
            let folderId = whoElseBatches ? whoElseBatches[i].folderId ?  whoElseBatches[i].folderId : 'inbox' : 'inbox'
            let moveToInboxApi = `/users/${whoElseBatches[i].email}/messages/${whoElseBatches[i].messageId}/move`
            let moveToInboxReq = {
                id: whoElseBatches[i].id,
                method: 'POST',
                url: moveToInboxApi,
                headers: { 
                "Authorization": `Bearer ${whoElseBatches[i].token}`,
                "Content-Type": "application/json"
                },
                body : { "destinationId": folderId }
            };
            recoverRequests.push(moveToInboxReq)
        }
        let recoverResponses = []
        recoverResponses = await outlookBatchProcess(recoverRequests,whoElseBatches[0].token)
        resolve(recoverResponses)
    })
}


export default {
    processMoveEmailTrash: (data) => {
        return moveEmailTrash(data);
    },
    processMoveEmailDelete: (data) => {
        return moveEmailDelete(data);
    },
    processMoveEmailInbox: (data) => {
        return moveEmailInbox(data);
    }
}