import credentials from './credentials';
import moveEmailOutlook from './move-email-outlook';

const moveEmail = (data) => {
    return new Promise (async (resolve,reject)=>{
        const { companyId, email, domainId, internetMessageId, folderId } = data

        const isWhoElse = await db.WhoElse.findOne({ internetMessageId, to: email})
        if(isWhoElse){
            let { token } = await credentials.getCredentials(companyId, domainId)
            let whoElseRequest = [];
            
            whoElseRequest.push({
                id: isWhoElse._id.toHexString(),
                email: isWhoElse.to,
                token: token.access_token,
                messageId: isWhoElse.messageId
            })
            await moveEmailOutlook.processMoveEmailTrash(whoElseRequest)
            .then(async (response) => {
                if(response[0].status == 200 || response[0].status == 201){
                    isWhoElse.isErrorWhileMoving = {
                        isError: false,
                        message: ''
                    }
                    isWhoElse.isTrashed = true;
                    isWhoElse.messageId = response[0].body.id;
                    await isWhoElse.save();
                    resolve(folderId) ;
                }
                else{
                    console.log('Error moving the mail to trash for same reported mail for this user!')
                    isWhoElse.isErrorWhileMoving = {
                        isError: true,
                        message: "Mail not found in inbox or wrong query"
                    }
                    await isWhoElse.save();
                    reject(new RequestError("Mail not found in inbox!")) ;  
                }
            })
            .catch(async err => {
                console.log('Error moving the mail to trash for same reported mail for this user!--',err)
                isWhoElse.isErrorWhileMoving = {
                    isError: true,
                    message: err
                }
                await isWhoElse.save();
                reject(err) ;
            })
        }
        else resolve(folderId);
    })
}
export default {
    processTrashWhoElse: async(data) => {
        return moveEmail(data)
    }
}