import axios from "axios"
import config from '../config'

const sync = (company) =>{
    return new Promise(async (resolve,reject)=>{
        try {
            console.log({company})
        let res = await axios.get(`${process.env.TCM_URL}/api/client-management/package/get-packages`, {
                headers: {
                    Authorization: `Bearer ${company.packageAccessKey}`
                },
                ...(config.proxy.enableForCM && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            });


        let {packageDetails} = res.data;
        if(packageDetails?.lastModifiedPackageId === company?.lastModifiedPackageId){
            console.log("Package not modified");
            resolve(false);
        }else{
            console.log("The Latest package details are: ", packageDetails);
        }

        await db.Company.updateOne({
            _id: company._id
        }, {
            lastModifiedPackageId: packageDetails.lastModifiedPackageId
        })
       const incomingFeatureCodes = packageDetails.parameters.map(param => param.featureCode);

       await db.CompanyFeature.deleteMany({
           companyId: company._id,
           featureCode: { $nin: incomingFeatureCodes },
       });

       console.log("Outdated features removed.");

       const existingFeatureCodes = await db.CompanyFeature.find(
           { companyId: company._id },
           { featureCode: 1 }
       ).lean();

       const existingFeatureCodeSet = new Set(existingFeatureCodes.map(f => f.featureCode));

       const newFeatures = [];
       for (const parameter of packageDetails.parameters) {
           if (!existingFeatureCodeSet.has(parameter.featureCode)) {
               const feature = await db.Feature.findOne(
                   { featureCode: parameter.featureCode }
               ).lean();

               if (feature) {
                   newFeatures.push({
                       featureId: feature._id,
                       companyId: company._id,
                       featureCode: feature.featureCode,
                   });
               }
           }
       }

       if (newFeatures.length > 0) {
           await db.CompanyFeature.insertMany(newFeatures);
           console.log(`${newFeatures.length} new features added.`);
       } else {
           console.log("No new features to add.");
       }

       console.log("Features synchronized successfully.");
       resolve(true)
            
      } catch (error) {
            console.log("Error from get package",error)
            reject(error)
        }
    })
}

const setPackage = (company, packageDetails) =>{
    return new Promise(async (resolve,reject)=>{
        try {

            await db.Company.updateOne({
                _id: company._id
            }, {
                lastModifiedPackageId: packageDetails.lastModifiedPackageId,
                packageAccessKey: packageDetails.packageAccessKey
            })
           const incomingFeatureCodes = packageDetails.parameters.map(param => param.featureCode);
    
           await db.CompanyFeature.deleteMany({
               companyId: company._id,
               featureCode: { $nin: incomingFeatureCodes },
           });
    
           console.log("Outdated features removed.");
    
           const existingFeatureCodes = await db.CompanyFeature.find(
               { companyId: company._id },
               { featureCode: 1 }
           ).lean();
    
           const existingFeatureCodeSet = new Set(existingFeatureCodes.map(f => f.featureCode));
    
           const newFeatures = [];
           for (const parameter of packageDetails.parameters) {
               if (!existingFeatureCodeSet.has(parameter.featureCode)) {
                   const feature = await db.Feature.findOne(
                       { featureCode: parameter.featureCode }
                   ).lean();
    
                   if (feature) {
                       newFeatures.push({
                           featureId: feature._id,
                           companyId: company._id,
                           featureCode: feature.featureCode,
                       });
                   }
               }
           }
    
           if (newFeatures.length > 0) {
               await db.CompanyFeature.insertMany(newFeatures);
               console.log(`${newFeatures.length} new features added.`);
           } else {
               console.log("No new features to add.");
           }
    
           console.log("Features synchronized successfully.");
        resolve(true);
            
        } catch (error) {
            console.log("Error from set package",error)
            resolve(false)
        }
    })
}

export default {
    syncPackageDetails: (data) =>{
        return sync(data)
    },
    setPackageDetails: (company, packageDetails) =>{
        return setPackage(company, packageDetails)
    }
}