import { MailParser } from "mailparser-mit";

export default {
    parseEml: (eml) => {
        return new Promise((resolve, reject) => {
            let mailparser = new MailParser({
                showAttachmentLinks: true
            });
            mailparser.on("end", function (mail_object) {
                resolve(mail_object)
            });
            mailparser.write(eml);
            mailparser.end();
        })
    },
    parseHeader: (header) => {
        return new Promise((resolve, reject) => {
            let mailparser = new MailParser();
            mailparser.on("end", function (mail_object) {
                resolve(mail_object)
            });
            mailparser.write(header);
            mailparser.end();
        })
    }
}