import parseDomain from "parse-domains";

import getIp from './get-ip';
import parseEmail from './parse-email';

const getipAddress = function (receivedHeaders) {
    let ip = null;
    receivedHeaders.
    forEach(header => {
        const match = header.match(/\b(?:\d{1,3}\.){3}\d{1,3}\b/);
        if(match) {
            ip = match[0]
        }
    });
    return ip;
}

const stringSearcher = function (str, key) {
    let keyList = [];
    if (typeof key === 'string') keyList.push(key);
    else if (Array.isArray(key)) keyList = key;
    if (str && str.length > 0) {
        if (key.length == 0) return 'fail';
        let filteredList = keyList.filter((iKey) => str.indexOf(iKey) != -1)
        if (filteredList.length > 0) {
            return 'pass';
        } else return 'fail';
    } else {
        return 'fail';
    }
}

const getParseHeader = async (header, status = true ) => {
    try {
        let investigate = {};
        let parseEml = header
        if(status) parseEml = await parseEmail.parseHeader(header);
        if(parseEml && parseEml.from){
            let from = parseEml.from[0].address;
            let spfDomain = parseEml.headers['return-path'] ? 
                                Array.isArray(parseEml.headers['return-path'])? 
                                parseEml.headers['return-path'][0].split("@")[1]: 
                                parseEml.headers['return-path'].split("@")[1]: 
                            null;
            let parsedDomain = from.split('@')[1];
            let fromDomain = parsedDomain;
            investigate['spfAllignment'] = (fromDomain == spfDomain);
            let dkimSiganture = parseEml.headers['dkim-signature']
            if (Array.isArray(dkimSiganture)) {
                let search = `d=${fromDomain}`
                let filteredDkimSiganture = dkimSiganture.filter(r => r.includes(search))
                if (filteredDkimSiganture.length > 0) dkimSiganture = filteredDkimSiganture[0];
                else if (dkimSiganture > 0) dkimSiganture = dkimSiganture[0];
                else dkimSiganture = null; 
            }
            let authResults = parseEml.headers['authentication-results'];
            authResults = ((Array.isArray(authResults) && authResults.length > 0) ? authResults.filter(r => r.startsWith('amazonses.com')).join(" ") : authResults);
            let dkimDomain = ((dkimSiganture && dkimSiganture!=null) ? 
            (function() {
                let dIndex = dkimSiganture.search(/d=.*?;/);
                let dValue = dkimSiganture.slice(dIndex + 2, dkimSiganture.indexOf(";", dIndex + 2));
                return dValue;
            })() : null);
        
            parsedDomain = dkimDomain ? await parseDomain(dkimDomain) : null;
            dkimDomain = parsedDomain ? `${parsedDomain.domain}`: dkimDomain;
            investigate['dkimAllignment'] = (fromDomain == dkimDomain);
            investigate['senderIp'] = await getipAddress(parseEml.headers['received']);
            let { country, continent } = await getIp.processIp(investigate['senderIp']);
            if (country && continent) {
                investigate['country'] = country;
                investigate['continent'] = continent
            } else {
                investigate['country'] = 'NOT FOUND';
                investigate['continent'] = 'NOT FOUND';
            }
            investigate['spf'] = stringSearcher(authResults, 'spf=pass');
            investigate['dkim'] = stringSearcher(authResults, 'dkim=pass');
            investigate['dmarc'] = stringSearcher(authResults, ['dmarc=pass', 'dmarc=none']);
            return investigate; 
        } else {
            console.error('error from parsing header details');
            return {};
        }
    } catch (err) {
        console.log(err);
        return {};
    }
}
export default {
    processHeader : (header, status) => {
        return getParseHeader(header, status);
    }
}