import credentials from "./credentials";
import processGsuiteGroups from './get-gsuite-groups';
import processOutlookGroups from './get-outlook-groups';

export default {
    process: async( companyId, domainId, domainType, partialGroupName ) => {
        try {
            const creds = await credentials.getCredentials(companyId, domainId);
            if(domainType == 'Outlook'){
                return processOutlookGroups.processGroups(creds, partialGroupName);
            } 
            if(domainType == 'Gsuite'){
                return processGsuiteGroups.processGroups(creds, partialGroupName);
            }
        } catch (error) {
            await db.Domain.updateOne({
                _id: domainId
            }, {
                isSyncingUser: false,
                syncEndAt: new Date(),
                isSyncingUserError:true,
                isSyncingUserErrorFile: JSON.stringify(error)
            })
            throw new RequestError('Invalid credentials',429);
        }
    }
}