import credentials from "./credentials";
import processGsuiteUser from './get-gsuite-users';
import processOutlookUser from './get-outlook-users';
import { updateSyncingStatusOfGroups } from "./update-syncing-status-groups";

export default {
    process: async( companyId, domainId, domainName, subDomainGroups, domainType, nextLink, isExchange, group, creds, isMirrorSync=false, allUsersGroupId=null, syncTs=new Date(), pageIndex=0 ) => {
        try {
            // const creds = await credentials.getCredentials(companyId, domainId);
            if(domainType == 'Outlook'){
                return processOutlookUser.processUser(domainId, domainName, subDomainGroups, companyId, creds, nextLink, isExchange, group, isMirrorSync, allUsersGroupId, syncTs, pageIndex);
            } 
            if(domainType == 'Gsuite'){
                let nextPageToken = null
                return processGsuiteUser.processUser(domainId, domainName, subDomainGroups, companyId, creds, nextPageToken, group, isMirrorSync, allUsersGroupId, syncTs, pageIndex);
            }
        } catch (error) {
            console.log("Error in processUser:", error);
            await updateSyncingStatusOfGroups(group._id, companyId)
            await db.Domain.updateOne({
                _id: domainId
            }, {
                isSyncingUser: false,
                syncEndAt: new Date(),
                isSyncingUserError:true,
                isSyncingUserErrorFile: JSON.stringify(error)
            })
            throw new RequestError('Invalid credentials',429);
        }
    }
}