const fs = require('fs');
const axios = require('axios');
const path = require('path')
import config from '../config'

// OpenAI API Key
const api_key = config.openai.key

// Function to encode the image
function encodeImage(imagePath) {
  const image = fs.readFileSync(imagePath);
  return Buffer.from(image).toString('base64');
}

const process = (fileName, preferedLanguage='english') => {
    console.log("Process Message function ==>==>==> Processing file:", fileName, "with preferred language:", preferedLanguage);
    return new Promise((resolve, reject) => {
        try {
            const imagePath = path.join(appRoot, 'Content', 'whatsappImages', fileName)
            const base64Image = encodeImage(imagePath);
            const headers = {
            "Content-Type": "application/json",
            "Authorization": `Bearer ${api_key}`
            };

            // const payload = {
            // "model": "gpt-4-turbo",
            // "messages": [
            //     {
            //     "role": "user",
            //     "content": [
            //         {
            //         "type": "text",
            //         // "text": `Your Task: I am sending you image of text messages. I want you to ignore partially visible messages in the screenshot but analyse the fully visible messages, and segregate each message into a block(a key value JS object). This message must have the following keys only( Sender, Message Body, Safety Parameter, Description, Links). Here, safety parameter can have values 'safe','dubious' or 'unsafe' which should be deco, Description key should contain a brief reasoning of why it is it marked so and Links is the key that should be an array of links that were present in that message(it should be empty when no links are present in the message). I want you to include the previous mentioned details in an array of each blocks. Additionally I want you to send another array containing an object that has key 'descision' based on overall conversation's safety which you must evalute by parsing whole conversation(valid values are 'safe','dubious' or 'unsafe') only, I dont want any explanation for the overall. Wrap these two arrays in a singleArray. [Must keep in points]: 1. If message has a highlighted part, strictly ignore the non highlighted text. 2. You should include fully visible messages only. 3. The format should not be json or a codeblock.... [[{ block1 details}, { block2 details}...], [{ decision}]] where a block has shape { "Sender": string, "Message Body": string, "Safety Parameter", 'Description', 'Links'}. 4. Strictly stick to this format, do not add any message from your side 5. I want you restrict these output length to 1024 and you are allowed to abbreviate message body such as (starting words ..... end Words).`
            //         "text": `Your Task: I am sending you an image of text messages. Ignore partially visible messages in the screenshot and analyze only fully visible messages. Segregate each message into a block (a key-value JavaScript object). Each message must have the following keys only:  - **Sender** (string)   - **Message Body** (string, abbreviated if necessary)   - **Safety Parameter** (strictly one of: 'safe', 'dubious', or 'unsafe' in the **same language** as the message text)   - **Description** (brief reasoning for classification in the **same language** as the message text)   - **Links** (array of links found in the message; empty if none)    Include these details in an **array of message blocks**. Additionally, provide another array containing an object with the key 'decision', which represents the **overall conversation safety evaluation**. The **decision** value must also be in the **same language** as the message text.  ### **Important Context-Based Analysis:**   1. **Analyze Full Conversation First:** Read the **entire conversation** before classifying individual messages.   2. **Context-Aware Message Analysis:** If a message's meaning or safety depends on another message, **consider the related messages before making a decision.**   3. **Language Matching Rule:** The entire output, including 'Safety Parameter' and 'Description', must be in the **same language** as the text in the image.   4. **Highlighted Text Rule:** If a message has a highlighted part, strictly ignore the non-highlighted text.   5. **Message Visibility Rule:** Process only fully visible messages; ignore cut-off texts.   6. **Format Rule:** The response **must** be in this exact structure (no JSON, no extra text):      [[{ block1 details }, { block2 details }...], [{ decision }]]      Each block follows:      { "Sender": "...", "Message Body": "...", "Safety Parameter": "...", "Description": "...", "Links": [...] }   7. **Output Length Limit:** Keep responses **under 1024 characters**. If needed, abbreviate the **Message Body** (e.g., "Starting words...ending words").   8. **Consistency Rule:** Apply the same safety classification logic across runs to avoid different results for the same message.   9. **No Extra Text:** Do **not** add explanations, apologies, or introductory phrases—only return the structured response.`  
            //     }
            //     ]
            //     },
            //     {
            //     "role": "user",
            //     "content": [
            //         {
            //         "type": "image_url",
            //         "image_url": {
            //             "url": `data:image/jpeg;base64,${base64Image}`
            //         }
            //         }
            //     ]
            //     }
            // ],
            // "max_tokens": 4096
            // };
            console.log("preferredLanguage before payload---------", preferedLanguage);
            const payload = {
                "model": "gpt-4-turbo",
                "messages": [
                    {
                        "role": "user",
                        "content": [
                            // {
                            //     "type": "text",
                            //     "text": `Your Task: I am sending you an image of text messages. Ignore partially visible messages in the screenshot and analyze only fully visible messages. Segregate each message into a block (a key-value JavaScript object). Each message must have the following keys only:  
                                
                            //     - **Sender** (string)  
                            //     - **Message Body** (string, abbreviated if necessary)  
                            //     - **Safety Parameter** (**strictly one of:** translated equivalents of 'safe', or 'potentially unsafe' in the **same language** as the message text)  
                            //     - **Description** (brief reasoning for classification in the **same language** as the message text)  
                            //     - **Links** (array of links found in the message; empty if none)  
            
                            //     Include these details in an **array of message blocks**. Additionally, provide another array containing an object with the key 'decision', which represents the **overall conversation safety evaluation**. The **decision** value must also be in the **same language** as the message text.  
            
                            //     ### **Important Context-Based Analysis:**  
                            //     1. **Analyze Full Conversation First:** Read the **entire conversation** before classifying individual messages.  
                            //     2. **Context-Aware Message Analysis:** If a message's meaning or safety depends on another message, **consider the related messages before making a decision.**  
                            //     3. **Language-Adaptive Safety Labels:** Translate 'safe', 'dubious', and 'unsafe' into the detected language of the messages and use them consistently.  
                            //     4. **Highlighted Text Rule:** If a message has a highlighted part, strictly ignore the non-highlighted text.  
                            //     5. **Message Visibility Rule:** Process only fully visible messages; ignore cut-off texts.  
                            //     6. **Format Rule:** The response **must** be in this exact structure (no JSON, no extra text):  
            
                            //        [[{ block1 details }, { block2 details }...], [{ decision }]]  
            
                            //        Each block follows:  
            
                            //        { "Sender": "...", "Message Body": "...", "Safety Parameter": "...", "Description": "...", "Links": [...] }  
            
                            //     7. **Output Length Limit:** Keep responses **under 1024 characters**. If needed, abbreviate the **Message Body** (e.g., "Starting words...ending words").  
                            //     8. **Consistency Rule:** Apply the same safety classification logic across runs to avoid different results for the same message.  
                            //     9. **No Extra Text:** Do **not** add explanations, apologies, or introductory phrases—only return the structured response.`
                            // }
                            {
                                "type": "text",
                                "text": `IMPORTANT: Keep the following field names exactly in English — Sender, Message Body, Safety Parameter, Description, Links, decision, summary. Translate ONLY the field VALUES into ${preferedLanguage}. If any value or free-text appears in another language, your response will be rejected.
                                        
                                Your Task: I am sending you an image of text messages. Ignore partially visible messages in the screenshot and analyze only fully visible messages. Segregate each message into a block (a key-value JavaScript object). Each message must have the following keys only:               
                                - **Sender** (string)  
                                - **Message Body** (string, abbreviated if necessary)  
                                - **Safety Parameter** (**strictly one of:** translated equivalents of 'safe', or 'potentially unsafe' in ${preferedLanguage} )  
                                - **Description** (brief reasoning for classification in ${preferedLanguage} )  
                                - **Links** (array of links found in the message; empty if none)  
                            
                                Include these details in an **array of message blocks**. Additionally, provide another array containing an object with the following keys:  
                            
                                - **decision** – The **overall conversation safety evaluation** in ${preferedLanguage}.  
                                - **summary** – A **single concise description** summarizing the **entire conversation's context and safety evaluation**, similar to this example for an unsafe conversation:  
                                  *No, do not click the link in this message. This is a phishing attempt. The message pretends to be from Bank BRI, asking you to click a link to confirm or activate something related to tariffs or banking services. However, the link (zyrosite.com) is not a legitimate domain associated with Bank BRI and is likely designed to steal personal information or install malware.*  
                            
                                ### **Important Context-Based Analysis:**  
                                1. **Analyze Full Conversation First:** Read the **entire conversation** before classifying individual messages.  
                                2. **Context-Aware Message Analysis:** If a message's meaning or safety depends on another message, **consider the related messages before making a decision.**  
                                3. **Language-Adaptive Safety Labels:** Translate 'safe', 'dubious', and 'unsafe' into the detected language of the messages and use them consistently.  
                                4. **Highlighted Text Rule:** If a message has a highlighted part, strictly ignore the non-highlighted text.  
                                5. **Message Visibility Rule:** Process only fully visible messages; ignore cut-off texts.  
                                6. **Format Rule:** The response **must** be in this exact structure (no JSON, no extra text):  
                            
                                   **[[{ block1 details }, { block2 details }...], [{ decision, summary }]]**  
                            
                                   Each block follows:  
                            
                                   { "Sender": "...", "Message Body": "...", "Safety Parameter": "...", "Description": "...", "Links": [...] }  
                            
                                7. **Output Length Limit:** Keep responses **under 1024 characters**. If needed, abbreviate the **Message Body** (e.g., "Starting words...ending words").  
                                8. **Consistency Rule:** Apply the same safety classification logic across runs to avoid different results for the same message.  
                                9. **No Extra Text:** Do **not** add explanations, apologies, or introductory phrases—only return the structured response.`
                            }                            
                        ]
                    },
                    {
                        "role": "user",
                        "content": [
                            {
                                "type": "image_url",
                                "image_url": {
                                    "url": `data:image/jpeg;base64,${base64Image}`
                                }
                            }
                        ]
                    }
                ],
                "max_tokens": 4096
            };
            

            axios.post("https://api.openai.com/v1/chat/completions", payload, { 
                headers,
                ...(config.proxy.enableForOpenAI && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            })
            .then(response => {
                if(response && response.data && response.data.choices && response.data.choices.length) resolve(response.data.choices[0].message)
                else resolve(false)
            })
            .catch(error => {
                console.error('Error:', error.response.data);
            });
        } catch (err) {
            console.error(err);
            reject(err);
        }
    });
};


export default {
    processMessage: async( fileName, preferedLanguage ) => {
        return process(fileName, preferedLanguage);
    }
}
