import axios from 'axios';
import config from '../config';

const registerCompanyWithTa = async function (data) {
    try {
        return new Promise((resolve, reject) => {
            axios.post(`${process.env.TAC_URL}/api/sync-services/common/register-company-with-application`,{...data},
                {
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': `Bearer ${config.adminCentral.api_key}`
                    },
                    params:{
                        appName:"TPIR"
                    },
                    ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
                }
            )
            .then(res => {
                console.log("-------",res?.data?.data)
                resolve(res?.data?.data)
            })
            .catch(error => {
                const statusCode = error.status || 500; // Use a default of 500 if no specific error status is defined
                const isClientError = statusCode >= 400 && statusCode < 500;
            
                // Log the error internally
                console.error('API Error:', error);
            
                // Respond with a generic error message for server errors to avoid exposing details
                const responseMessage = isClientError ? 
                    (error.message || "The request could not be processed.") : 
                    "An internal server error occurred.";
            
                console.log({
                    success: false,
                    message: responseMessage,
                    // Include more specific error details only if it's safe to expose them
                    error: isClientError ? {
                        code: error.code || "UNEXPECTED_ERROR", // Custom or generic error code
                        description: error.description || null // Optional additional info
                    } : undefined
                });
                reject(error)
        
            })
        })
    } catch (err) {
                const statusCode = err.status || 500; // Use a default of 500 if no specific error status is defined
                const isClientError = statusCode >= 400 && statusCode < 500;
            
                // Log the error internally
                console.error('API Error:', err);
            
                // Respond with a generic error message for server errors to avoid exposing details
                const responseMessage = isClientError ? 
                    (err.message || "The request could not be processed.") : 
                    "An internal server error occurred.";
            
                console.log({
                    success: false,
                    message: responseMessage,
                    // Include more specific error details only if it's safe to expose them
                    error: isClientError ? {
                        code: err.code || "UNEXPECTED_ERROR", // Custom or generic error code
                        description: err.description || null // Optional additional info
                    } : undefined
                })
                reject(err)

    }
}

export default registerCompanyWithTa
    