import axios from 'axios';
import config from '../config';

const scanResult = (data) => {
	return new Promise(async(resolve, reject) => {
		let request = {
			method: 'get',
			url: `https://www.virustotal.com/vtapi/v2/url/report?apikey=${data.apikey}&resource=${data.scan_id}`,
		};
		if (config.proxy.enableForVirusTotal) {
			request.httpsAgent = config.proxy.proxyAgent;
			request.httpAgent = config.proxy.proxyAgent;
		}
		axios.request(request)
		.then(res => res.data)
		.then(data => {
			resolve(data);
		})
		.catch(err => {
			reject(err);
		})
	})
}
export default {
    processScanResult: async(data) => {
        return scanResult(data)
    }
}