import axios from "axios"
import config from "../config"
const routeMailTsat = async (data) =>{
    try {
        return new Promise((resolve,reject)=>{
            console.log(data)
            const axiosConfig = {};
            if (config.proxy.enableForThreatCop) {
                axiosConfig.httpsAgent = config.proxy.proxyAgent;
                axiosConfig.httpAgent = config.proxy.proxyAgent;
            }
            axios.post(`${data.tsatUrl.value}/api/report`,{
                header: data.header,
                body: data.body,
            }, axiosConfig)
            .then((response)=>{
                console.log(data)
                console.log("url------------>",`${data.tsatUrl.value}/api/report`)
                if(response && response.data){
                    console.log("----------->",response.data)
                    resolve(true)
                }
            })
            .catch((error)=>{
                console.log("Error from routing mail to TSAT",error)
                resolve(false)
            })
        }) 
        
    } catch (error) {
        console.log("Error from routing mail to TSAT")
        resolve(false)
    }
}

export default {
    routeMail: (data) =>{
        return routeMailTsat(data)
    }
}