import axios from 'axios';
import fs from 'fs';
import config from '../config';

export async function saveImage(uri, filePath, accessToken) {
  return new Promise((resolve, reject) => {
    console.log("Inside saveImage --", uri);
    axios({
      method: "GET",
      url: uri,
      headers: { Authorization: `Bearer ${accessToken}` },
      responseType: "stream",
      ...(config.proxy.enableForWhatsapp && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
    })
      .then(response => {
        response.data
          .pipe(fs.createWriteStream(filePath))
          .on("finish", () => {
            console.log("Image saved successfully at", filePath);
            resolve(true);
          })
          .on("error", (err) => {
            console.log("Error while saving image:", err);
            reject(err);
          });
      })
      .catch((err) => {
        console.log("Error while downloading image:", err);
        resolve(false);
      });
  });
}
