import axios from 'axios';
import { queue } from '../kue';
import config from '../config';

const scanAttachment = (formData) => {
	return new Promise(async(resolve, reject) => {
		let request = {
			method: 'post',
			url: 'https://www.virustotal.com/vtapi/v2/file/scan',
			data: formData
		};
		if (config.proxy.enableForVirusTotal) {
			request.httpsAgent = config.proxy.proxyAgent;
			request.httpAgent = config.proxy.proxyAgent;
		}
		axios.request(request)
		.then(res => res.data)
		.then(data => {
			resolve(data);
		})
		.catch(err => {
			console.log(JSON.stringify(err));
			reject(err);
		})
	})
	
}
export default {
    processScanAttachment: async(formData, attachmentId, companyId) => {
		return scanAttachment(formData)
		.then(data => {
			console.log('attachments', { data });
			queue.create('attachment-report', { attachmentId, companyId, data }).attempts(5).delay(60000).backoff({type:'exponential'}).removeOnComplete(true).save()
			.on('failed', async function(errorMessage){
				await db.Attachment.updateOne({
					_id: attachmentId,
				}, {
					status: 'FAILED',
				})
			})
			return db.Attachment.updateOne({
				_id: attachmentId,
			}, {
				details: data,
				scanId: data.scan_id
			})

		})
		.catch(err => {
			return db.Attachment.updateOne({
				_id: attachmentId,
			}, {
				status: 'FAILED',
				result: JSON.stringify(err)
			})
		})
    }
}