import axios from 'axios';
import { queue } from '../kue';
import config from '../config';

const scanURL = (data) => {
	return new Promise(async(resolve, reject) => {
		let request = {
			method: 'post',
			url: 'https://www.virustotal.com/vtapi/v2/url/scan',
			data: data
		};
		if (config.proxy.enableForVirusTotal) {
			request.httpsAgent = config.proxy.proxyAgent;
			request.httpAgent = config.proxy.proxyAgent;
		}
		axios.request(request)
		.then(res => res.data)
		.then(data => {
			resolve(data);
		})
		.catch(err => {
			console.log(JSON.stringify(err));
			reject(err);
		})
	})
	
}
export default {
    processScanURL: async(data, urlId, companyId) => {
        return scanURL(data)
		.then(data => {
			console.log('url', { data });
			queue.create('url-report', { urlId, data, companyId }).delay(30000).removeOnComplete(true).save();
			return db.Url.updateOne({
				_id: urlId,
			}, {
				details: data,
				scanId: data.scan_id
			})
		})
		.catch(err => {
			console.log('errrrrrrrrrrrrr',err)
			return db.Url.updateOne({
				_id: urlId,
			}, {
				status: 'FAILED',
				details: JSON.stringify(err)
			})
		})
    },
	processScanWaURL: async(data, urlId, companyId) => {
        return scanURL(data)
		.then(data => {
			console.log('url', { data });
			queue.create('url-wa-report', { urlId, data, companyId }).delay(30000).removeOnComplete(true).save();
			return db.Url.updateOne({
				_id: urlId,
			}, {
				details: data,
				scanId: data.scan_id
			})
		})
		.catch(err => {
			console.log('errrrrrrrrrrrrr',err)
			return db.Url.updateOne({
				_id: urlId,
			}, {
				status: 'FAILED',
				details: JSON.stringify(err)
			})
		})
    }
}