import axios from "axios";
import config from '../config'
import { whatsappActionTemplate } from "../functions";
const accessToken = config.whatsapp.accessToken;


const whatsappMessage = (phone_number_id, ticketId, to, message, result, template, preferedLanguage) => {
  return new Promise((resolve, reject) => {
    console.log(phone_number_id, ticketId, to, message, result, template)
  
  let template = whatsappActionTemplate(ticketId, result, preferedLanguage);

  axios.post(`https://graph.facebook.com/v16.0/${phone_number_id}/messages`, {
    messaging_product: "whatsapp",
    to,
    text: { body: template },
  }, {
    headers: { "Content-Type": "application/json", Authorization: `Bearer ${accessToken}` },
    ...(config.proxy.enableForWhatsapp && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
  })
  .then((response) => {
    console.log("responseeeeeeeeeeee",response.data)
    if (response.status == 200) {
      console.log(`Successfully sent message----> ${message}`)
      resolve(true);
      } else {
        resolve(false);
      }
  })
  .catch((error) => {
    // console.log("Error from sending whatsapp message", error);
    reject(error);
    });
  });


};


export default {
  sendMessage: async(phone_number_id, ticketId, to, message, result, template, preferedLanguage) => {
      return whatsappMessage(phone_number_id, ticketId, to, message, result, template, preferedLanguage);
  }
}



