import axios from 'axios';
import config from '../config';

export const syncDomainsFromTa = async (companyId) => {
    let company = await db.Company.findOne({ _id: companyId });
    
    if (!company) throw new RequestError("Company not found", 404);

    const response = await axios.get(
        `${process.env.TAC_URL}/api/sync-services/common/fetch-company-verified-domains/TPIR`,
        {
            headers: { Authorization: `Bearer ${config.adminCentral.api_key}` },
            params: { alias: company.alias, appName: "TPIR" },
            ...(config.proxy.enableForTA && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
        }
    );

    let domains = response?.data?.response?.verifiedDomains || [];
    let domainIds = [];

    for (let domain of domains) {
        if (domain.type !== null && domain.type !== "other") {
            let domainRecord = await db.Domain.findOne({
                domainName: domain.domainName,
                companyId: company._id
            });

            if (!domainRecord) {
                domainRecord = await db.Domain.create({
                    domainName: domain.domainName,
                    txtRecord: domain.txtRecord,
                    isVerified: true,
                    companyId: companyId,
                    domainType: domain.type === "Google Workspace" ? "Gsuite" : "Outlook",
                    isCredential: false,
                    credential: null,
                    isSyncingUser: false,
                    isSyncingUserError: false,
                    isSyncingUserErrorFile: false,
                    domainTypeForOutlook: domain.type === "Google Workspace" ? null : 
                        domain.type === "Microsoft Outlook (Exchange)" ? 'EXCHANGE' : "OFFICE365",
                });

                if (domain?.subDomains?.length) {
                    await Promise.all(
                        domain.subDomains.map(async (subDomain) => {
                            const existingSubDomain = await db.SubDomainGroup.findOne({
                                groupName: subDomain,
                                domainId: domainRecord._id,
                                companyId: company._id
                            });

                            if (!existingSubDomain) {
                                return db.SubDomainGroup.create({
                                    groupName: subDomain,
                                    domainId: domainRecord._id,
                                    companyId: company._id
                                });
                            }
                        })
                    );
                }
            }

            if (domainRecord?.deletedAt !== null) {
                await db.Domain.updateOne({ _id: domainRecord._id }, { $set: { deletedAt: null } });
            }

            domainIds.push(domainRecord._id);
        }
    }

    await db.Domain.updateMany(
        { companyId: company._id, _id: { $nin: domainIds } },
        {
            $set: {
                isSyncingUser: false,
                isSyncingUserError: false,
                isSyncingUserErrorFile: false,
                isCredential: false,
                credential: null,
                deletedAt: new Date()
            }
        }
    );

    return domainIds;
};
