
const check = (companyId) => {
    return new Promise(async (resolve, reject) => {
        try {
            const operationsCountWhoElse = await db.ReportedMail.countDocuments({
                companyId, 
                isWhoElseProcessing: true, 
                deletedAt: null
              });

            const operationsCountSimilarEmail = await db.ReportedMail.countDocuments({
                companyId, 
                isSimiliarEmailProcessing: true, 
                deletedAt: null
              });
              
              const syncOperationCount = await db.Group.countDocuments({
                companyId, 
                isSyncingUsers: true, 
                deletedAt: null
              });
              
              let result = operationsCountWhoElse > 0 || operationsCountWhoElse > 0 ||  syncOperationCount > 0 ? false : true;
              resolve(true)
            //   resolve(result)
              
        } catch (err) {
            console.error(err);
            reject(err);
        }
    });
};


export default {
    isSyncOperationPermitted: async(companyId) => {
        return check(companyId);
    }
}
