import axios from "axios";
import config from "../config";
import { AzureErrorHandler } from "../errors";

const azureConfig = {
    email : {
        link: (fromAddress) => config.azure.sendEmailUrl.replace('{{fromAddress}}', fromAddress)
    }
}

export default {
    triggerEmail: async ({ fromAddress, payload, token, logErrorMessage }) => {
        try {
          console.log('Sending email via Azure', { fromAddress, payload, token });
          const startTime= performance.now();
          const response = await axios.post(azureConfig.email.link(fromAddress), payload, {
                headers: {
                    Authorization: `Bearer ${token}`,
                    'Content-Type': 'application/json',
                },
                ...(config.proxy.enableForMicrosoftGraph && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
            });
            const endTime= performance.now();
            const buildResponse= {
                message: 'Email sent successfully',
                responseStatus: response.status,
                responseStatusString: response.statusText,
                successResponseData: response.data
            }
            return { response: buildResponse, timeTaken: ((endTime-startTime)/1000).toFixed(3)};
        } catch(error) {
            throw new AzureErrorHandler('Failed to send email via Azure', {
                operationType: 'email',
                error,
                code: error.response?.status || 500,
                logInternally: logErrorMessage
            });
        }
    }
}