export let updateActivationStautsOfUsers = async (companyId) => {
    try {
        let activeGroupsOfCompanyWithEmailAccess = await db.Group.find({ companyId, deletedAt: null, emailAccess: true }).select("_id")
        let activeGroupsOfCompanyWithMessengerAccess = await db.Group.find({ companyId, deletedAt: null, messengerAccess: true }).select("_id")

        await db.User.updateMany({companyId, groups: { $nin: activeGroupsOfCompanyWithEmailAccess }, deletedAt: null },{ $set: { isActive: false }})
        await db.User.updateMany({companyId, groups: { $nin: activeGroupsOfCompanyWithMessengerAccess }, deletedAt: null },{ $set: { isActiveMessenger: false }})

    } catch (error) {
        console.log(error);
    }
}