export let updateGroupStatusAfterSync = async (groupId, companyId) => {
    try {
        const allUsersGroup = await db.Group.findOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null})
        const currentGroup = await db.Group.findOne({companyId, isDefaultGroup: false, _id: groupId, deletedAt: null})

        let groupsOfCompanyWhichHaveEmailAccess = await db.Group.find({companyId, deletedAt:null, emailAccess: true}).select('_id')
        let groupsOfCompanyWhichHaveMessengerAccess = await db.Group.find({companyId, deletedAt:null, messengerAccess: true})
        

        const countOfUsersInAllUsersGroup = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in: [allUsersGroup._id]}})
        const countOfUsersInCurrentGroup = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in: [currentGroup._id]}})

        const emailLimit = (await db.MetaData.findOne({name:"userLimit", companyId, deletedAt: null})).value
        const messengerLimit = (await db.MetaData.findOne({name:"userLimitMessenger", companyId, deletedAt: null})).value


        if(allUsersGroup.emailAccess){
            if(countOfUsersInAllUsersGroup > emailLimit){
                await db.Group.updateOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null},{$set:{emailAccess: false}})
                await db.User.updateMany({ companyId, deletedAt: null, groups: { $nin: [groupsOfCompanyWhichHaveEmailAccess] } },{$set:{isActive:false}})
            }
        } 
        if(allUsersGroup.messengerAccess){
            if(countOfUsersInAllUsersGroup > messengerLimit){
                await db.Group.updateOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null},{$set:{messengerAccess: false}})
                await db.User.updateMany({ companyId, deletedAt: null, groups: { $in: [groupsOfCompanyWhichHaveMessengerAccess] } },{$set:{isActiveMessenger:false}})
            }
        }    

        if(currentGroup.emailAccess){
            if(countOfUsersInCurrentGroup > emailLimit){
                await db.Group.updateOne({companyId, _id:groupId, isDefaultGroup: false, deletedAt: null},{$set:{emailAccess: false}})
                await db.User.updateMany({ companyId, deletedAt: null, groups: { $in: [groupsOfCompanyWhichHaveEmailAccess] } },{$set:{isActive:false}})
            }
        } 
        if(currentGroup.messengerAccess){
            if(countOfUsersInCurrentGroup > messengerLimit){
                await db.Group.updateOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null},{$set:{messengerAccess: false}})
                await db.User.updateMany({ companyId, deletedAt: null, groups: { $in: [groupsOfCompanyWhichHaveMessengerAccess] } },{$set:{isActiveMessenger:false}})
            }
        }    


    } catch (error) {
        console.log(error);
    }
}