import axios from "axios";
import config from "../config";

let outlookBatchProcess = async (requests, token) => {
    let data = { requests };
    let axiosRequestConfig = {
        method: 'POST',
        url: 'https://graph.microsoft.com/v1.0/$batch/',
        headers: { "content-type": "application/json", authorization: `Bearer ${token}`, Prefer: 'outlook.allow-unsafe-operations'},
        data: data,
        ...(config.proxy.enableForMicrosoftGraph && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
    }
    let response = await axios.request(axiosRequestConfig)
    let result = response.data.responses
    return result;
}




const update = (mailBoxRequests, token) => {
    return new Promise(async (resolve, reject) => {
        try {
            let mailBoxResponses = [];
            mailBoxResponses = await outlookBatchProcess(mailBoxRequests, token.access_token)
            
            let updatesArray = [];
            for(let i=0;i<mailBoxResponses.length;i++){
                if(mailBoxResponses[i] && mailBoxResponses[i].status==200 && mailBoxResponses[i].body && mailBoxResponses[i].body.value.length &&  mailBoxResponses[i].body.value[0].id){
                    updatesArray.push({
                        updateOne:{
                            filter: { _id: mailBoxResponses[i].id },
                            update: { messageId: mailBoxResponses[i].body.value[0].id },
                        }
                    })
                }
            }
            console.log(updatesArray[0])
            const updateWhoElse = await db.WhoElse.bulkWrite(updatesArray)
            console.log(updateWhoElse)
            resolve(updatesArray)

        } catch (error) {
            console.log(error.response)
            resolve(false)
        }

    })
}



export default {
    processUpdateMessageId: (whoElseIds, token) => {
        return update(whoElseIds, token);
    }
}