export let updateSyncingStatusOfGroups = async (groupId, companyId) => {
    try {
        const checkGroupWhichAreInSyncingStateOtherThanCurrentGroup = await db.Group.find({_id:{$ne: groupId}, companyId, isSyncingUsers: true, isDefaultGroup: false}) 
        if(!checkGroupWhichAreInSyncingStateOtherThanCurrentGroup.length) await db.Group.updateOne({groupName: "all-users-tpir", isDefaultGroup: true, companyId},{$set:{isSyncingUsers: false}}) 
        await db.Group.updateOne({_id: groupId, companyId},{$set:{isSyncingUsers: false}})    
    
        const allUsersGroup = await db.Group.findOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null})
        const currentGroup = await db.Group.findOne({companyId, isDefaultGroup: false, _id: groupId, deletedAt: null})

        let groupsOfCompanyWhichHaveEmailAccess = await db.Group.find({companyId, deletedAt:null, emailAccess: true}).select('_id')
        let groupsOfCompanyWhichHaveMessengerAccess = await db.Group.find({companyId, deletedAt:null, messengerAccess: true})
        

        const countOfUsersInAllUsersGroup = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in: [allUsersGroup._id]}})

        const emailLimit = parseInt((await db.MetaData.findOne({name:"userLimit", companyId, deletedAt: null})).value)
        const messengerLimit = parseInt((await db.MetaData.findOne({name:"userLimitMessenger", companyId, deletedAt: null})).value)


        if(allUsersGroup.emailAccess){
            if(countOfUsersInAllUsersGroup > emailLimit){
                await db.Group.updateOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null},{$set:{emailAccess: false}})
                await db.User.updateMany({ companyId, deletedAt: null, groups: { $nin: [groupsOfCompanyWhichHaveEmailAccess] } },{$set:{isActive:false}})
            }
        } 
        if(allUsersGroup.messengerAccess){
            if(countOfUsersInAllUsersGroup > messengerLimit){
                await db.Group.updateOne({companyId, groupName:"all-users-tpir", isDefaultGroup: true, deletedAt: null},{$set:{messengerAccess: false}})
                await db.User.updateMany({ companyId, deletedAt: null, groups: { $in: [groupsOfCompanyWhichHaveMessengerAccess] } },{$set:{isActiveMessenger:false}})
            }
        }    

        if(currentGroup){
            const countOfUsersInCurrentGroup = await db.User.countDocuments({companyId, deletedAt:null, groups:{$in: [currentGroup._id]}})
            if(currentGroup.emailAccess){
                if(countOfUsersInCurrentGroup > emailLimit){
                    await db.Group.updateOne({companyId, _id:groupId, isDefaultGroup: false, deletedAt: null},{$set:{emailAccess: false}})
                    await db.User.updateMany({ companyId, deletedAt: null, groups: { $in: [groupsOfCompanyWhichHaveEmailAccess] } },{$set:{isActive:false}})
                }
            } 
            if(currentGroup.messengerAccess){
                if(countOfUsersInCurrentGroup > messengerLimit){
                    await db.Group.updateOne({companyId, _id:groupId, isDefaultGroup: false, deletedAt: null},{$set:{messengerAccess: false}})
                    await db.User.updateMany({ companyId, deletedAt: null, groups: { $in: [groupsOfCompanyWhichHaveMessengerAccess] } },{$set:{isActiveMessenger:false}})
                }
            }    
        }

    } catch (error) {
        console.log(error);
    }
}

// export let updateSyncingStatusOfGroups = async (groupId, companyId) => {
//     try {
//         const [
//             allUsersGroup,
//             currentGroup,
//             groupsOfCompanyWhichHaveEmailAccess,
//             groupsOfCompanyWhichHaveMessengerAccess,
//             countOfUsersInAllUsersGroup,
//             emailLimitMeta,
//             messengerLimitMeta
//         ] = await Promise.all([
//             db.Group.findOne({ companyId, groupName: "all-users-tpir", isDefaultGroup: true, deletedAt: null }),
//             db.Group.findOne({ companyId, isDefaultGroup: false, _id: groupId, deletedAt: null }),
//             db.Group.find({ companyId, deletedAt: null, emailAccess: true }).select('_id'),
//             db.Group.find({ companyId, deletedAt: null, messengerAccess: true }),
//             db.User.countDocuments({ companyId, deletedAt: null, groups: { $in: [allUsersGroup?._id] } }),
//             db.MetaData.findOne({ name: "userLimit", companyId, deletedAt: null }),
//             db.MetaData.findOne({ name: "userLimitMessenger", companyId, deletedAt: null })
//         ]);

//         if (!allUsersGroup || !currentGroup) throw new Error('Default groups not found.');

//         const emailLimit = parseInt(emailLimitMeta?.value || '0');
//         const messengerLimit = parseInt(messengerLimitMeta?.value || '0');

//         // Update syncing status for groups
//         const otherSyncingGroups = await db.Group.find({
//             companyId,
//             _id: { $ne: groupId },
//             isSyncingUsers: true,
//             isDefaultGroup: false
//         });

//         if (otherSyncingGroups.length === 0) {
//             await db.Group.updateOne({ companyId, groupName: "all-users-tpir", isDefaultGroup: true }, { $set: { isSyncingUsers: false } });
//         }

//         await db.Group.updateOne({ companyId, _id: groupId }, { $set: { isSyncingUsers: false } });

//         // Check and update user limits for email access
//         if (allUsersGroup.emailAccess && countOfUsersInAllUsersGroup > emailLimit) {
//             await Promise.all([
//                 db.Group.updateOne({ companyId, groupName: "all-users-tpir", isDefaultGroup: true }, { $set: { emailAccess: false } }),
//                 db.User.updateMany({ companyId, deletedAt: null, groups: { $nin: groupsOfCompanyWhichHaveEmailAccess } }, { $set: { isActive: false } })
//             ]);
//         }

//         // Check and update user limits for messenger access
//         if (allUsersGroup.messengerAccess && countOfUsersInAllUsersGroup > messengerLimit) {
//             await Promise.all([
//                 db.Group.updateOne({ companyId, groupName: "all-users-tpir", isDefaultGroup: true }, { $set: { messengerAccess: false } }),
//                 db.User.updateMany({ companyId, deletedAt: null, groups: { $in: groupsOfCompanyWhichHaveMessengerAccess } }, { $set: { isActiveMessenger: false } })
//             ]);
//         }

//         // Handle current group email and messenger limits
//         if (currentGroup) {
//             const countOfUsersInCurrentGroup = await db.User.countDocuments({ companyId, deletedAt: null, groups: { $in: [currentGroup._id] } });

//             if (currentGroup.emailAccess && countOfUsersInCurrentGroup > emailLimit) {
//                 await Promise.all([
//                     db.Group.updateOne({ companyId, _id: groupId, isDefaultGroup: false }, { $set: { emailAccess: false } }),
//                     db.User.updateMany({ companyId, deletedAt: null, groups: { $in: groupsOfCompanyWhichHaveEmailAccess } }, { $set: { isActive: false } })
//                 ]);
//             }

//             if (currentGroup.messengerAccess && countOfUsersInCurrentGroup > messengerLimit) {
//                 await Promise.all([
//                     db.Group.updateOne({ companyId, _id: groupId, isDefaultGroup: false }, { $set: { messengerAccess: false } }),
//                     db.User.updateMany({ companyId, deletedAt: null, groups: { $in: groupsOfCompanyWhichHaveMessengerAccess } }, { $set: { isActiveMessenger: false } })
//                 ]);
//             }
//         }

//     } catch (error) {
//         console.error('Error during syncing status update:', error.message || error);
//         throw error
//     }
// };
