import axios from 'axios';
import credentials from "./credentials";
import config from "../config";

const getGroups = async (credential) =>{
    try {
        let axiosRequestConfig = {
            method: 'GET',
            url: 'https://graph.microsoft.com/v1.0/groups?$select=id,displayName',
            headers: { 
                'content-type': 'application/json', 
                authorization: `Bearer ${credential.token.access_token}` 
            },
            ...(config.proxy.enableForMicrosoftGraph && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
        };
        let apiRespo = await axios.request(axiosRequestConfig) 
        if(apiRespo && apiRespo.data) return apiRespo.data.value
    } catch (error) {
        console.log(error.response.data)
        throw new RequestError("Error fetching groups")
    }
} 


export default {
    get: async( companyId, domainId ) => {
        const creds = await credentials.getCredentials(companyId, domainId);
        return getGroups(creds);
    }
}