import fs from 'fs'
import path from 'path'
import axios from 'axios';
import config from '../config';
import { queue } from '../kue';
import { saveImage } from './saveWhatsappImage';
import { randomString } from '../functions';
import getLanguageFormattedMessage from './languageService';

const accessToken = config.whatsapp.accessToken;

async function getImageImageUrl(imageId) {
  try {
    console.log("Inside getImageImageUrl with imageId --", imageId);
    const response = await axios.get(`https://graph.facebook.com/v16.0/${imageId}`, {
      headers: { Authorization: `Bearer ${accessToken}` },
      ...(config.proxy.enableForWhatsapp && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
    });
    return response.data;
  } catch (err) {
    console.log("Error fetching image URL:", err.response.data);
    return false;
  }
}

export async function sendWhatsappMessage(phone_number_id, message, to, messageId) {
  try {
    const response = await axios.post(`https://graph.facebook.com/v16.0/${phone_number_id}/messages`, {
      messaging_product: "whatsapp",
      to,
      text: { body: message },
      context: { message_id: messageId },
    }, {
      headers: { "Content-Type": "application/json", Authorization: `Bearer ${accessToken}` },
      ...(config.proxy.enableForWhatsapp && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
    });

    if (response.status === 200) {
      console.log(`Successfully sent message: ${message}`);
      return true;
    }
    return false;
  } catch (err) {
    console.log("Error sending WhatsApp message:", err.response.data);
    return false;
  }
}

export async function processImageMessage(phone_number_id, from, message, name, companyId, userId) {
  const image_id = message.image.id;
  const messageId = message.id;
  const image = await getImageImageUrl(image_id);
  if (!image) {
    console.log("Error fetching image from WhatsApp!");
    return;
  }

  console.log('Imageggggegegegeggegegeggegegegege',image)

  const filename = `${Date.now()}.${image.mime_type.split("/")[1]}`;
  const filePath = path.join(appRoot, "Content", "whatsappImages", filename);

  console.log("File path:", filePath);

  // directory exists
  const dir = path.dirname(filePath);
  if (!fs.existsSync(dir)) {
    fs.mkdirSync(dir, { recursive: true });
    console.log("Directory created:", dir);
  }

  const imageSave = await saveImage(image.url, filePath, accessToken);
  if (!imageSave) {
    console.log("Error saving the image!");
    return;
  } 

  const preferedLanguage = await db.Company.findOne({ _id: companyId }).select("whatsappLanguage");
  console.log("Prefered language:---------", preferedLanguage);

  const ticketId = `TPIR#${randomString(6)}`;
  let msg = await getLanguageFormattedMessage("acknowledgment", preferedLanguage?.whatsappLanguage, {ticketId})
  // let msg = `*Ticket ID - ${ticketId}*. \n\nThank you for reporting to us. We will shortly provide you with the results.\n\n \`Thank you for the commitment to online safety.\``
  
  const sentMessage = await sendWhatsappMessage(phone_number_id, msg, from, messageId);
  if (!sentMessage) {
    console.log("Error sending prompt message!");
    return;
  }

  const reportedMessage = await db.whatsapp.create({
    from: name,
    phoneNumber: from,
    phoneNumberId: phone_number_id,
    messageId: message.id,
    type: 'image',
    imageId: image_id,
    imageUrl: image.url,
    fileName: filename,
    ticketId,
    companyId,
    userId
  });

  queue.create('process-whatsapp-image', { reportedMessage, ticketId, to: from, companyId, preferedLanguage:preferedLanguage?.whatsappLanguage }).removeOnComplete(true).priority('high').save();
  console.log("Image successfully downloaded and saved in directory!");
}
