export async function cleanupMirrorGroup({ companyId, groupId, syncTs }) {
  const staleFilter = {
    companyId,
    groups: groupId,
    lastAdSeenAt: { $ne: syncTs },
  };
  // Step 1: Remove users from the group if not seen in this sync
  await db.User.updateMany(
    staleFilter,
    { $pull: { groups: groupId } }
  );

  // Step 2: Soft-delete users who are AD synced but have no groups left
  await db.User.updateMany(
    {
      companyId,
      isADSynced: true,
      deletedAt: null,
      groups: { $size: 0 }
    },
    {
      $set: { deletedAt: new Date() }
    }
  );
}


export async function orphanSweepManualGroups({ companyId }) {
    // 1) get all users still AD-synced
    const activeIds = await db.User.distinct('_id', {
        companyId, isADSynced: true, deletedAt: null
      });
    
      // 2) manual group IDs
      const manualGroupIds = await db.Group.distinct('_id', {
        companyId, isADSynced: false, deletedAt: null
      });
    
      // 3) pull those orphan users out of manual groups
      await db.User.updateMany(
        { companyId, _id: { $nin: activeIds } },
        { $pull: { groups: { $in: manualGroupIds } } }
      );
      console.log(
        `Removed ${activeIds.length} users from ${manualGroupIds.length} manual groups in company ${companyId}`
      );
}