
const path = require('path');
const { gmail_v1, google } = require('googleapis');

function parsedHeader(result){
    let emailData = result.data.payload.headers;
    let bodyData = ''
    if (result.data.payload.body.data !== undefined) {
        bodyData = result.data.payload.body.data;
    } else if (result.data.payload.parts.length) {
        bodyData = result.data.payload.parts[1].body.data;
    }
    let decodedBodyData = ''
    if (bodyData) {
        let bufferObj = Buffer.from(bodyData, "base64");
        decodedBodyData = bufferObj.toString("utf8");
    } else {
        bodyData = result.data.payload.parts[0].parts[1].body.data
        if (bodyData) {
            let bufferObj = Buffer.from(bodyData, "base64");
            decodedBodyData = bufferObj.toString("utf8");
        }
    }

    let searchData = {};
    for (let resObj of emailData) {
        if (resObj.name === 'Delivered-To') {
            searchData['to'] = resObj.value;
        }
        if (resObj.name === 'To') {
            let toMail = resObj.value;
            let tomail = toMail.match(/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/);
            searchData['To'] = [... new Set(tomail)];
        }
        if (!searchData['to'] && resObj.name === 'To') {
            let to = resObj.value;
            to = to.match(/([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4})/gi)[0];
            searchData['to'] = to;
        }
        if (resObj.name === 'From') {
            let from = resObj.value;
            from = from.match(/([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4})/gi)[0];
            searchData['from'] = from;
        }
        if (resObj.name === 'Subject') {
            searchData['subject'] = resObj.value;
        }
        if (resObj.name === 'Date') {
            searchData['date'] = resObj.value;
        }
        if (resObj.name === 'Cc' || resObj.name === 'CC') {
            let ccMail = resObj.value;
            let ccmail = ccMail.match(/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/);
            searchData['cc'] = [... new Set(ccmail)];
        }
    }

    searchData['body'] = decodedBodyData;
    return searchData;
}

function processAdvancedSearchGsuite(data){
    return new Promise(async (resolve) => {
        try {
            let { to, fileName, filter } = data;
            let credentialFilePath = path.join(__dirname, '..', 'Content', 'Credentials', fileName);
            const authClient = new google.auth.JWT({
                keyFile: credentialFilePath,
                scopes: [
                    'https://mail.google.com/', 
                    'https://www.googleapis.com/auth/admin.directory.user'],
                subject: to,
            });
            await authClient.authorize();
            const gmail = new gmail_v1.Gmail({ auth: authClient });
            const result = await gmail.users.messages.list({
                q: filter,
                userId: to,
                auth: authClient,
                includeSpamTrash: true
            });
            console.log(result.data);
            if(result.status == 200 && result?.data?.messages){
                data['isMailFound'] = [];
                for(let i=0; i<result.data.messages.length; i++){
                    console.log(result.data.messages[i]);
                    const message = await gmail.users.messages.get({
                        userId: to,
                        auth: authClient,
                        id: result.data.messages[i].id,
                    });
                    let parsed = await parsedHeader(message);

                    parsed['messageId'] = result.data.messages[i].id;
                    parsed['threadId'] = result.data.messages[i].threadId;

                    data['isMailFound'].push(parsed);
                }
            } else {
                data['isMailFound'] = []
            }
            resolve(data);
        } catch(err){
            console.log(err);
            data['isMailFound'] = []
            resolve(data);
        }
    })
}

module.exports = processAdvancedSearchGsuite;