const path = require('path');
const { gmail_v1, google } = require('googleapis');

function processWhoElseGsuite(data){
    return new Promise(async (resolve, reject) => {
        try {
            // console.log('processing who else gsuite', data.index, data.email, data.from, data.subject);
            let { email, from, fileName, subject, name, internetMessageId } = data;
            let credentialFilePath = path.join(__dirname, '..', 'Content', 'Credentials', fileName);
            const authClient = new google.auth.JWT({
                keyFile: credentialFilePath,
                scopes: [
                    'https://mail.google.com/', 
                    'https://www.googleapis.com/auth/admin.directory.user'],
                subject: email,
            });
            await authClient.authorize();
            const gmail = new gmail_v1.Gmail({ auth: authClient });
            const result = await gmail.users.messages.list({
                q: `from=${from} subject=${subject} rfc822msgid:${internetMessageId}`,
                userId: email,
                auth: authClient,
                includeSpamTrash: true,
                });
            
            if(result.status == 200 && result?.data?.messages) {
            console.log("------------------>",result.data.messages)
           
            } 
            if(result.status == 200 && result?.data?.messages){

                const checkLabel = await gmail.users.messages.get({
                    id: result.data.messages[0].id,
                    userId: email,
                    auth: authClient,
                    includeSpamTrash: true,
                    });
                const labels = checkLabel.data.labelIds
                console.log(labels)
                console.log(labels.includes('INBOX'))
                data['isMailFound'] = {
                    'messageId': result.data.messages[0].id,
                    'threadId': result.data.messages[0].threadId,
                    'isTrashed': labels.includes('TRASH') ? true : false
                };
            } else {
                data['isMailFound'] = null
            }
            console.log('done who else gsuite', data.index);
            resolve(data);
        } catch(err){
            data['isMailFound'] = null
            reject(err);
        }
    })
}

module.exports = processWhoElseGsuite;