import axios from 'axios';
import config from '../config';

let outlookBatchProcess = async (requests, token) => {
    try {
        let data = { requests };
        let axiosConfig = {
            method: 'POST',
            url: 'https://graph.microsoft.com/v1.0/$batch/',
            headers: { 'content-type': 'application/json', authorization: `Bearer ${token}` },
            data: data,
            ...(config.proxy.enableForMicrosoftGraph && { httpsAgent: config.proxy.proxyAgent, httpAgent: config.proxy.proxyAgent })
        }
        let response = await axios.request(axiosConfig)
        let result = response.data.responses
        return result;
    } catch (error) {
        console.log(error)
        return []
    }
}

function processWhoElseOutlook(data, isLast) {
    return new Promise(async (resolve) => {
        
        let trashRequests = []
        let messageMap = {}

        for (let i = 0; i < data.length; i++) {
            const { subject, from, email, userId, internetMessageId, mailAction } = data[i];
            // const escapedSubject = subject?.replace(/'/g, "''");

            let checkTrashApi = `/users/${email}/mailFolders/deleteditems/messages?$select=id,subject,from,internetMessageId,parentFolderId&$filter=internetMessageId eq '${encodeURIComponent(internetMessageId)}'`;
            let checkTrashReq = {
                id: email,
                method: 'GET',
                url: checkTrashApi,
            };
            trashRequests.push(checkTrashReq)
            messageMap[email] = data[i]
        }

        let trashResponses = [];
        trashResponses = await outlookBatchProcess(trashRequests, data[0].token);

        let mailResults = []
        let inboxRequests = [];

        for (let i = 0; i < trashResponses.length; i++) {
            if (trashResponses[i].status == 200) {
                let isMailFound = trashResponses[i].body.value[0];
                if (isMailFound && isMailFound.id) {
                    let messageData = messageMap[trashResponses[i].id]
                    mailResults.push({
                        from: messageData.from,
                        subject: messageData.subject,
                        reportedMailId: messageData.reportedMailId,
                        companyId: messageData.companyId,
                        domainId: messageData.domainId,
                        isLast: messageData.isLast,
                        internetMessageId: messageData.internetMessageId,
                        messageId: isMailFound.id,
                        name:messageData.name,
                        emailUserId: messageData.emailUserId ? messageData.emailUserId : null,
                        email: messageData.email,
                        foundInTrash: true,
                        foundInInbox: false,
                        mailAction: messageData.mailAction
                    })
                }
            }
            if (trashResponses[i].status == 404 || (trashResponses[i].status == 200 && trashResponses[i].body.value && !trashResponses[i].body.value.length && !trashResponses[i].body.value[0])) {
                // const escapedSubjectForInbox = data[0]?.subject?.replace(/'/g, "''");

                inboxRequests.push({
                    id: trashResponses[i].id,
                    method: "GET",
                    url: `/users/${trashResponses[i].id}/messages?$select=id,subject,from,internetMessageId,parentFolderId&$filter=internetMessageId eq '${encodeURIComponent(data[0].internetMessageId)}'`,
                });
            }
        }

        let inboxResponses = []
        if (inboxRequests.length) {
            inboxResponses = await outlookBatchProcess(inboxRequests, data[0].token)
        }

        for (let i = 0; i < inboxResponses.length; i++) {
            if (inboxResponses[i].status == 200) {
                let isMailFound = inboxResponses[i].body.value[0];
                if (isMailFound && isMailFound.id) {
                    let messageData = messageMap[inboxResponses[i].id]
                    mailResults.push({
                        from: messageData.from,
                        subject: messageData.subject,
                        reportedMailId: messageData.reportedMailId,
                        companyId: messageData.companyId,
                        domainId: messageData.domainId,
                        email: messageData.email,
                        isLast: messageData.isLast,
                        internetMessageId: messageData.internetMessageId,
                        messageId: isMailFound.id,
                        name:messageData.name,
                        emailUserId: messageData.emailUserId ? messageData.emailUserId : null,
                        email: messageData.email,
                        foundInInbox: true,
                        foundInTrash: false,
                        mailAction: messageData.mailAction,
                        folderId: isMailFound.parentFolderId
                    })
                }
            }
        }
        resolve(mailResults)
    })
}

export default processWhoElseOutlook;