'use strict'

const WorkerPool = require('workerpool');

async function processDNSBL(...args) {
    const { default: mod } = await import('./processing_dnsbl.js');
    return mod(...args);
}

/* for whoelse */
async function processWhoElseGsuite(...args) {
    const { default: mod } = await import('./processing_whoelse_gsuite.js');
    return mod(...args);
}
async function processWhoElseOutlook(...args) {
    const { default: mod } = await import('./processing_whoelse_outlook.js');
    return mod(...args);
}

/* for advanced search */
async function processAdvancedSearchGsuite(...args) {
    const { default: mod } = await import('./processing_advanced_search_gsuite.js');
    return mod(...args);
}
async function processAdvancedSearchOutlook(...args) {
    const { default: mod } = await import('./processing_advanced_search_outlook.js');
    return mod(...args);
}

/* for similiar email search */
async function processSimiliarSearchOutlook(...args) {
    const { default: mod } = await import('./processing_similiar_search_outlook.js');
    return mod(...args);
}
async function processSimiliarSearchGsuite(...args) {
    const { default: mod } = await import('./processing_similiar_search_gsuite.js');
    return mod(...args);
}

WorkerPool.worker({
    processDNSBL,
    processWhoElseGsuite,
    processWhoElseOutlook,
    processAdvancedSearchGsuite,
    processAdvancedSearchOutlook,
    processSimiliarSearchOutlook,
    processSimiliarSearchGsuite
});
