'use strict'

const Path = require('path')
const WorkerPool = require('workerpool')

let poolProxy = null;

const init = async (options) => {
    const pool = WorkerPool.pool(Path.join(__dirname, './thread-functions.js'), options);
    poolProxy = await pool.proxy();
    console.log("\x1b[32mWorkerpool:\x1b[0m", `Worker Threads Enabled - Min Workers: 1 - Max Workers: ${pool.maxWorkers} - Worker Type: ${pool.workerType}`)
}

const get = () => {
    return poolProxy
}

exports.init = init
exports.get = get