"use strict";
exports.id = 3283;
exports.ids = [3283];
exports.modules = {

/***/ 3283:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "I": () => (/* binding */ AppContext),
/* harmony export */   "w": () => (/* binding */ AppProvider)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_api__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9473);
/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9915);
/* harmony import */ var _utils_routes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(7727);
/* harmony import */ var _utils_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3250);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_utils_api__WEBPACK_IMPORTED_MODULE_2__, js_cookie__WEBPACK_IMPORTED_MODULE_3__, _utils_error__WEBPACK_IMPORTED_MODULE_5__]);
([_utils_api__WEBPACK_IMPORTED_MODULE_2__, js_cookie__WEBPACK_IMPORTED_MODULE_3__, _utils_error__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const AppContext = /*#__PURE__*/ (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)();
const AppProvider = ({ children  })=>{
    const { 0: domains , 1: setDomains  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    const { 0: domainChange , 1: setDomainChange  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const { 0: isLite , 1: setisLite  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const { 0: isMessengerEnabled , 1: setIsMessengerEnabled  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const { 0: features , 1: setFeatures  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const { 0: permissions , 1: setPermissions  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const router = (0,next_router__WEBPACK_IMPORTED_MODULE_6__.useRouter)();
    const token = js_cookie__WEBPACK_IMPORTED_MODULE_3__["default"].get("token");
    const unAuthenticatedPath = [
        // "/login",
        "/logout",
        // "/login/tac/[token]",
        "/register",
        "/forgot-password",
        "/reset-password/[email]/[token]",
        "/email-verification/[email]/[token]"
    ];
    react__WEBPACK_IMPORTED_MODULE_1___default().useEffect(()=>{
        if (token && unAuthenticatedPath.indexOf(router.pathname) === -1) {
            if (domains == "") {
                _utils_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"].get */ .Z.get(_utils_routes__WEBPACK_IMPORTED_MODULE_4__/* ["default"].DOMAIN.DOMAIN_LIST */ .Z.DOMAIN.DOMAIN_LIST).then((res)=>res.data).then((data)=>{
                    let domainSettings = {
                        exchange: false,
                        outlookOrGsuite: false
                    };
                    for(let i = 0; i < data?.domains.length; i++){
                        const domain = data.domains[i];
                        if (domain.domainType === "Outlook" && domain.domainTypeForOutlook === "OFFICE365" || domain.domainType === "Gsuite" && (domain.domainTypeForOutlook === null || domain.domainTypeForOutlook === "null")) {
                            domainSettings.outlookOrGsuite = true;
                        } else {
                            domainSettings.exchange = true;
                        }
                        if (domainSettings.exchange && domainSettings.outlookOrGsuite) break;
                    }
                    setDomains(domainSettings);
                }).catch((err)=>{
                    (0,_utils_error__WEBPACK_IMPORTED_MODULE_5__/* .apiError */ .q)(err);
                });
            }
        }
    }, [
        domainChange
    ]);
    react__WEBPACK_IMPORTED_MODULE_1___default().useEffect(()=>{
        if (token && unAuthenticatedPath.indexOf(router.pathname) === -1) {
            _utils_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"].get */ .Z.get(_utils_routes__WEBPACK_IMPORTED_MODULE_4__/* ["default"].SETTINGS.CHECK_PACKAGE */ .Z.SETTINGS.CHECK_PACKAGE).then((res)=>res.data).then((data)=>{
                setisLite(data.isLite);
                setFeatures(data.companyFeatures);
                if (data.companyFeatures.includes("TPIR-WA")) setIsMessengerEnabled(true);
                else setIsMessengerEnabled(false);
            });
        }
    }, [
        domainChange,
        isMessengerEnabled
    ]);
    react__WEBPACK_IMPORTED_MODULE_1___default().useEffect(()=>{
        if (token && unAuthenticatedPath.indexOf(router.pathname) === -1) {
            _utils_api__WEBPACK_IMPORTED_MODULE_2__/* ["default"].get */ .Z.get(_utils_routes__WEBPACK_IMPORTED_MODULE_4__/* ["default"].EMPLOYEE.PERMISSIONS */ .Z.EMPLOYEE.PERMISSIONS).then((res)=>res.data).then((data)=>{
                setPermissions(data.policies);
            });
        }
    }, [
        token
    ]);
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(AppContext.Provider, {
        value: {
            domains,
            setDomains,
            setDomainChange,
            isLite,
            isMessengerEnabled,
            setIsMessengerEnabled,
            features,
            permissions
        },
        children: children
    });
};


__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;