import React from 'react'
import { Box, Typography, Button, Modal,TextField, InputLabel } from '@mui/material'
import { toast } from 'react-toastify';

import api from '../../utils/api';
import routes from '../../utils/routes';
import { apiError } from '../../utils/error';
import { validateEmail } from '../../utils/common';
import styles from '../../styles/gsuitemodal.module.scss'
import CloseSharpIcon from '@mui/icons-material/CloseSharp';


export default function AddCredentialGsuite(props) {
    const { handleClose, domainId, open} = props;

    const [credential, setCredential] = React.useState({
        adminMail:'',
        file:'',
        domainId: domainId
    })

    const [credentialError, setCredentialError] = React.useState({
        adminMail :{ status : false, message : ''},
    })

    const handleChange = (e) =>{
        setCredentialError({...credentialError, [e.target.name]: { status:false, message:''}})
        setCredential({...credential, [e.target.name]: e.target.value})
    }

    const handleChangeFile = (e) =>{
        setCredential({...credential, file: e.target.files[0]})
    }

    const updateCredentials = () =>{

            let error = false

                if(!validateEmail(credential.adminMail)) {
                    setCredentialError({...credentialError, adminMail: { status:true, message:'Please Enter a valid mail!'}})
                    error = true;
                }
                if(!error){
				const formData = new FormData()
				formData.append('adminEmail', credential.adminMail)
				formData.append('domainId', credential.domainId)
				formData.append('file', credential.file)

					api.post(routes.CREDENTIAL.GSUITE, formData,{
                        headers: {
                          'Content-Type': 'multipart/form-data'
                        }
                    })
					.then((res) => res.data)
					.then((data) => {
						toast.success(data.message)
                        handleClose()
					})
					.catch((error) =>{
						apiError(error)
					})
                }
    }


    return (
        <Modal
            open={open}
            onClose={handleClose}
            aria-labelledby="modal-modal-title"
            aria-describedby="modal-modal-description"
        >
            <Box className={styles.MainGsuiteModal}>
            
                      <Box className={styles.modalHeader}>
                        <Typography id="modal-modal-title" variant="h6">
                        Add Gsuite Credential
                        </Typography>
                        <CloseSharpIcon className={styles.closeIcon} onClick={handleClose} />
                    </Box>
                   

                <Box className={styles.MidsettingWrap}>
                  <Box className={styles.FormBt}>
                    <InputLabel>Admin Email</InputLabel>
                    <TextField 
                        name='adminMail'
                        fullWidth  
                        size="small" 
                        placeholder="Enter Admin Email"
                        onChange={handleChange}
                        error={credentialError.adminMail.status}
                        helperText={credentialError.adminMail.message}
                        className={styles.InputFieldBox}/>
                    </Box>

                    <Box className={styles.FormBt}>
                    <InputLabel>Service File</InputLabel>
                    <TextField size="small" 
                    type="file" 
                    id="myFile" 
                    name="filename" 
                    onChange={handleChangeFile} 
                    helperText="*.json files are accepted."
                    accept=".json" 
                    fullWidth sx={{ mb: '14px' }} 
                    className={styles.InputFieldBox}/>

                    </Box>

                    <Box display="flex" justifyContent="flex-end" alignItems="flex-end">
                        <Button variant="contained" color="success" onClick={updateCredentials} >Update</Button>
                    </Box>
                </Box>
                </Box>  
          
        </Modal>
    )
}
